/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v126_commit_types;

import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.blacklist_v42_clone.MigrateV42CommitAssociatedObjectBase;
import com.teamscale.index.migration.blacklist_v42_clone.MigrateV42CommitDescriptor;
import com.teamscale.index.migration.blacklist_v42_clone.MigrateV42ParentedCommitDescriptor;
import com.teamscale.index.migration.v101_testdetails.migrated.V101ExternalAnalysisCommitInfo;
import com.teamscale.index.migration.v126_commit_types.migrated.V126EExternalAnalysisResultType;
import com.teamscale.index.migration.v126_commit_types.migrated.V126ExternalAnalysisCommitInfo;
import com.teamscale.index.migration.v48_external_analysis_result.unmigrated.V48ByteArrayWrapper;
import com.teamscale.index.migration.v48_external_analysis_result.unmigrated.V48KeyDelta;
import com.teamscale.index.migration.v48_external_analysis_result.unmigrated.V48StorageKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion126CommitTypes
extends BranchBasedStoreBatchMigratorBase {
    private static final byte[] EXTERNAL_ANALYSIS_COMMIT_KEY = StringUtils.stringToBytes((String)"#-#commit#-#");
    private final ClassNameMigrator classNameMigrator = new ClassNameMigrator();
    private final ConcurrentMap<ByteArrayWrapper, Set<V126EExternalAnalysisResultType>> cache = new ConcurrentHashMap<ByteArrayWrapper, Set<V126EExternalAnalysisResultType>>();

    public MigrateVersion126CommitTypes() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V126, true);
        this.classNameMigrator.registerUnmigratedClass("com.teamscale.index.external.ExternalAnalysisCommitInfo", V101ExternalAnalysisCommitInfo.class);
        this.classNameMigrator.registerMigratedClass("com.teamscale.index.external.ExternalAnalysisCommitInfo", V126ExternalAnalysisCommitInfo.class);
        this.classNameMigrator.registerMigratedClass("com.teamscale.index.external.status.EExternalAnalysisResultType", V126EExternalAnalysisResultType.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.CommitDescriptor", MigrateV42CommitDescriptor.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ParentedCommitDescriptor", MigrateV42ParentedCommitDescriptor.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.CommitAssociatedObjectBase", MigrateV42CommitAssociatedObjectBase.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.engine.index.core.KeyDelta", V48KeyDelta.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.engine.persistence.store.util.StorageKey", V48StorageKey.class);
        this.classNameMigrator.registerIntermediateClass("org.conqat.lib.commons.collections.ByteArrayWrapper", V48ByteArrayWrapper.class);
    }

    protected byte[] migrateValue(byte[] originalKey, byte[] value) throws StorageException {
        this.cache.put(new ByteArrayWrapper(CommitLayeringBranchingLayer.createReferenceKey((byte[])value)), this.extractTypes(value));
        return value;
    }

    protected void postProcessMigratedValues(PairList<byte[], byte[]> migratedValues, PairList<byte[], byte[]> deduplicatedMigratedValues) throws StorageException {
        int commitKeyIndex = this.findCommitKeyIndex(migratedValues);
        if (commitKeyIndex == -1) {
            return;
        }
        V101ExternalAnalysisCommitInfo commitInfo = (V101ExternalAnalysisCommitInfo)this.classNameMigrator.deserialize((byte[])migratedValues.getSecond(commitKeyIndex));
        EnumSet<V126EExternalAnalysisResultType> types = EnumSet.noneOf(V126EExternalAnalysisResultType.class);
        ArrayList<ByteArrayWrapper> references = new ArrayList<ByteArrayWrapper>();
        for (byte[] value : migratedValues.getSecondList()) {
            references.add(new ByteArrayWrapper(CommitLayeringBranchingLayer.createReferenceKey((byte[])value)));
        }
        for (Object reference : deduplicatedMigratedValues.getSecondList()) {
            references.add(new ByteArrayWrapper(reference));
        }
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            Object reference;
            reference = (ByteArrayWrapper)iterator.next();
            Set typesForRef = (Set)this.cache.get(reference);
            if (typesForRef == null) continue;
            types.addAll(typesForRef);
        }
        migratedValues.setSecond(commitKeyIndex, (Object)this.classNameMigrator.serialize(new V126ExternalAnalysisCommitInfo(commitInfo, types)));
    }

    private Set<V126EExternalAnalysisResultType> extractTypes(byte[] value) throws StorageException {
        EnumSet<V126EExternalAnalysisResultType> types = EnumSet.noneOf(V126EExternalAnalysisResultType.class);
        List<SerializedClass> classEntities = MigrateVersion126CommitTypes.getSerializedClasses(value);
        for (SerializedClass classEntity : classEntities) {
            V126EExternalAnalysisResultType type = V126EExternalAnalysisResultType.RESULT_TO_TYPE_MAPPING.get(classEntity.getName());
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    private static List<SerializedClass> getSerializedClasses(byte[] value) throws StorageException {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            return entityPool.getClassEntities();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private int findCommitKeyIndex(PairList<byte[], byte[]> migratedValues) {
        for (int i = 0; i < migratedValues.size(); ++i) {
            if (!Arrays.equals(EXTERNAL_ANALYSIS_COMMIT_KEY, (byte[])migratedValues.getFirst(i))) continue;
            return i;
        }
        return -1;
    }

    public String getStoreName() {
        return "external-analysis-results";
    }
}

