/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;

public abstract class NotificationMailHelperBase {
    protected final NotificationContext notificationContext;
    protected final String revisionLink;

    public NotificationMailHelperBase(NotificationContext notificationContext) throws StorageException {
        this.notificationContext = notificationContext;
        this.revisionLink = this.buildRevisionLink();
    }

    protected void appendCommitInformation(HTMLWriter writer) {
        RepositoryLogEntryAggregate logEntry = this.notificationContext.getRepositoryLogEntry();
        writer.openElement((Enum)EHTMLElement.P);
        writer.addText("Commit ");
        NotificationMailHelperBase.appendLink(writer, this.revisionLink, logEntry.getRevision());
        writer.addText(" matched your notification settings.");
        writer.closeElement((Enum)EHTMLElement.P);
        this.appendCommitInformationBody(writer);
    }

    protected void appendCommitInformationBody(HTMLWriter writer) {
        RepositoryLogEntryAggregate logEntry = this.notificationContext.getRepositoryLogEntry();
        writer.openElement((Enum)EHTMLElement.UL);
        writer.addClosedTextElement((Enum)EHTMLElement.LI, "Message: " + logEntry.getMessage(), new Object[0]);
        writer.addClosedTextElement((Enum)EHTMLElement.LI, "Author: " + logEntry.getAuthor(), new Object[0]);
        writer.addClosedTextElement((Enum)EHTMLElement.LI, "Project: " + this.getProjectReadableName(), new Object[0]);
        writer.addClosedTextElement((Enum)EHTMLElement.LI, "Branch: " + this.notificationContext.getCommit().getBranchName(), new Object[0]);
        writer.addClosedTextElement((Enum)EHTMLElement.LI, "Files: " + this.notificationContext.getRepositoryLogFileChurn().toString(), new Object[0]);
        writer.closeElement((Enum)EHTMLElement.UL);
    }

    protected void appendViewCommitInTeamscaleText(HTMLWriter writer) {
        if (this.revisionLink == null) {
            return;
        }
        writer.addText("Click ");
        NotificationMailHelperBase.appendLink(writer, this.revisionLink, "here");
        writer.addText(" to view the commit in Teamscale.");
    }

    protected static void appendLink(HTMLWriter writer, String link, String linkText) {
        if (link == null) {
            writer.addText(linkText);
        } else {
            writer.addClosedTextElement((Enum)EHTMLElement.A, linkText, new Object[]{EHTMLAttribute.HREF, link});
        }
    }

    private String buildRevisionLink() throws StorageException {
        String baseUrl = this.getBaseURL();
        if (baseUrl != null) {
            return new TeamscaleCommitLinkProvider(baseUrl, this.notificationContext.getPrimaryPublicId(), this.notificationContext.getCommit()).createCommitDetailsLink();
        }
        return null;
    }

    protected String getBaseURL() throws StorageException {
        return BaseUrlOption.getBaseUrl((GlobalStorageSystem)this.notificationContext.getGlobalStorageSystem());
    }

    protected String getProjectReadableName() {
        return this.notificationContext.getProjectReadableName();
    }
}

