/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.precommit.PreCommitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class PreCommitUploadCommit
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private final CommitDescriptor parentCommit;
    private final PairList<String, String> newFiles;
    private final PairList<String, String> changedFiles;
    private final List<String> deletedFiles;
    private final Set<String> testCodeFiles;

    public PreCommitUploadCommit(String preCommitBranchName, CommitDescriptor parentCommit, PairList<String, String> newFiles, PairList<String, String> changedFiles, Set<String> deletedFiles, Set<String> testCodeFiles) {
        super(new CommitDescriptor(preCommitBranchName, System.currentTimeMillis()));
        CCSMAssert.isNotNull((Object)parentCommit, () -> String.format("Expected \"%s\" to be not null", "parentCommit"));
        this.parentCommit = parentCommit;
        this.newFiles = new PairList(newFiles);
        CollectionUtils.sortByFirst(this.newFiles);
        this.changedFiles = new PairList(changedFiles);
        CollectionUtils.sortByFirst(this.changedFiles);
        this.deletedFiles = new ArrayList<String>(deletedFiles);
        Collections.sort(this.deletedFiles);
        this.testCodeFiles = new HashSet<String>(testCodeFiles);
    }

    public String getUsername() {
        return PreCommitUtils.extractPrecommitUserName((String)this.getCommit().getBranchName());
    }

    public CommitDescriptor getParentCommit() {
        return this.parentCommit;
    }

    public PairList<String, String> getNewFiles() {
        return this.newFiles;
    }

    public PairList<String, String> getChangedFiles() {
        return this.changedFiles;
    }

    public List<String> getDeletedFiles() {
        return this.deletedFiles;
    }

    public UnmodifiableSet<String> getTestFiles() {
        if (this.testCodeFiles == null) {
            return CollectionUtils.emptySet();
        }
        return CollectionUtils.asUnmodifiable(this.testCodeFiles);
    }

    public boolean isEmpty() {
        return this.newFiles.isEmpty() && this.changedFiles.isEmpty() && this.deletedFiles.isEmpty();
    }
}

