/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.index.quality_report.ImageSlideIndex;
import com.teamscale.index.quality_report.QualityReportsIndex;
import com.teamscale.index.quality_report.slides.IImageUsingSlide;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

@PeriodicMaintenanceJob(cronExpression="0 0 * * *")
public class ImageSlideCleanupTrigger
extends MaintenanceTriggerBase {
    public void execute() throws Exception {
        ImageSlideIndex imageSlideIndex = (ImageSlideIndex)this.indexLayer.openGlobalIndex(ImageSlideIndex.class);
        QualityReportsIndex qualityReportsIndex = (QualityReportsIndex)this.indexLayer.openGlobalIndex(QualityReportsIndex.class);
        ImageSlideCleanupTrigger.removeUnusedImages(imageSlideIndex, qualityReportsIndex);
    }

    @VisibleForTesting
    static void removeUnusedImages(ImageSlideIndex imageSlideIndex, QualityReportsIndex qualityReportsIndex) throws StorageException {
        Set allReferencedImageIds = qualityReportsIndex.getAllQualityReports().extractSecondList().stream().flatMap(report -> report.getSlides().stream()).filter(slide -> slide instanceof IImageUsingSlide).map(slide -> ((IImageUsingSlide)((Object)slide)).getUsedImageIds()).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet allUnusedIds = CollectionUtils.differenceSet(imageSlideIndex.getAllImageIds(), (Collection[])new Collection[]{allReferencedImageIds});
        imageSlideIndex.removeImages(allUnusedIds);
    }
}

