/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.QualityArtifactDescriptor;
import com.teamscale.index.quality_report.QualityArtifactMetaInfo;
import com.teamscale.index.quality_report.QualityArtifactProfile;
import com.teamscale.index.quality_report.ReportSlideBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class QualityReport
extends QualityArtifactDescriptor {
    private static final long serialVersionUID = 1L;
    private static final String RETROSPECTIVE_ID_PROPERTY = "retrospectiveId";
    private static final String REPORT_SLIDES_PROPERTY = "slides";
    private static final String SHOW_SLIDE_NUMBERS_PROPERTY = "showSlideNumbers";
    @JsonProperty(value="slides")
    private List<ReportSlideBase> slides;
    @JsonProperty(value="showSlideNumbers")
    private boolean showSlideNumbers;
    @JsonProperty(value="retrospectiveId")
    private @Nullable String retrospectiveId;

    @JsonCreator
    public QualityReport(@JsonProperty(value="metaInfo") QualityArtifactMetaInfo metaInfo, @JsonProperty(value="qualityArtifactProfile") QualityArtifactProfile qualityArtifactProfile, @JsonProperty(value="retrospectiveId") @Nullable String retrospectiveId, @JsonProperty(value="slides") List<ReportSlideBase> slides, @JsonProperty(value="showSlideNumbers") boolean showSlideNumbers) {
        super(metaInfo, qualityArtifactProfile);
        this.retrospectiveId = retrospectiveId;
        this.slides = slides;
        this.showSlideNumbers = showSlideNumbers;
    }

    public QualityReport(QualityReport report) {
        this(report.getMetaInfo(), report.getQualityArtifactProfile(), report.getRetrospectiveId(), report.slides, report.showSlideNumbers);
    }

    public QualityReport(QualityArtifactMetaInfo metaInfo, QualityArtifactProfile profile) {
        this(metaInfo, profile, null, new ArrayList<ReportSlideBase>(), false);
    }

    public @Nullable String getRetrospectiveId() {
        return this.retrospectiveId;
    }

    public void addSlide(ReportSlideBase<?, ?> slide) {
        this.slides.add(slide);
    }

    public void insertSlide(int index, ReportSlideBase<?, ?> slide) {
        this.slides.add(index, slide);
    }

    public void setShowSlideNumbers(boolean showSlideNumbers) {
        this.showSlideNumbers = showSlideNumbers;
    }

    public void setReportSlide(String targetSlideId, ReportSlideBase<?, ?> newSlide) {
        int slideIndex = this.getSlideIndex(targetSlideId);
        CCSMAssert.isFalse((slideIndex == -1 ? 1 : 0) != 0, (String)("Could not find slide with id '" + targetSlideId + "'"));
        this.slides.set(slideIndex, newSlide);
    }

    public void removeSlide(String slideId) {
        int slideIndex = this.getSlideIndex(slideId);
        if (slideIndex > -1) {
            this.slides.remove(slideIndex);
        }
    }

    public int getSlideIndex(String targetSlideId) {
        return CollectionUtils.indexOfFirstMatch(this.slides, slide -> targetSlideId.equals(slide.getId()));
    }

    public @Nullable ReportSlideBase findSlideById(String targetSlideId) {
        int slideIndex = this.getSlideIndex(targetSlideId);
        if (slideIndex == -1) {
            return null;
        }
        return this.slides.get(slideIndex);
    }

    public int hashCode() {
        return Objects.hash(this.getQualityArtifactProfile(), this.getMetaInfo(), this.slides.size());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualityReport other = (QualityReport)obj;
        return Objects.equals(this.getMetaInfo(), other.getMetaInfo()) && Objects.equals(this.getQualityArtifactProfile(), other.getQualityArtifactProfile()) && Objects.equals(this.slides.size(), other.slides.size());
    }

    public List<ReportSlideBase> getSlides() {
        return this.slides;
    }
}

