/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SelfContainedFinding;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.task.CodeSnippet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class TaskDetailSlide
extends ReportSlideBase<TaskDetailSlideParameters, TaskDetailSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.TASK_DETAIL;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskDetailSlide)) {
            return false;
        }
        TaskDetailSlideParameters thisSlideParameters = (TaskDetailSlideParameters)this.getSlideParameters();
        TaskDetailSlide otherTaskDetailSlide = (TaskDetailSlide)obj;
        TaskDetailSlideParameters otherSlideParameters = (TaskDetailSlideParameters)otherTaskDetailSlide.getSlideParameters();
        return Objects.equals(thisSlideParameters.projectBranchPath, otherSlideParameters.projectBranchPath) && Objects.equals(thisSlideParameters.taskId, otherSlideParameters.taskId) && Objects.equals(thisSlideParameters.codeFontSize, otherSlideParameters.codeFontSize) && Objects.equals(thisSlideParameters.slideTitle, otherSlideParameters.slideTitle) && Objects.equals(thisSlideParameters.comments, otherSlideParameters.comments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getSlideParameters(), this.getSlideType(), this.getTypeId()});
    }

    @IndexValueClass(containedInBackup=true)
    public static class TaskDetailSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projectBranchPath")
        @SlideParameter(formattedName="Project", type=ESlideOptionType.PROJECT)
        private ProjectBranchPath projectBranchPath;
        @JsonProperty(value="taskId")
        @SlideParameter(formattedName="Task ID", type=ESlideOptionType.STRING)
        private String taskId;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @JsonProperty(value="codeFontSize")
        @SlideParameter(formattedName="Code font size", type=ESlideOptionType.SIZE)
        private int codeFontSize;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        @JsonCreator
        TaskDetailSlideParameters() {
        }

        @VisibleForTesting
        public TaskDetailSlideParameters(ProjectBranchPath projectBranchPath, String taskId, String slideTitle, int codeFontSize, List<ISlideComment> comments) {
            this.projectBranchPath = projectBranchPath;
            this.slideTitle = slideTitle;
            this.taskId = taskId;
            this.codeFontSize = codeFontSize;
            this.comments = comments;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public int getCodeFontSize() {
            return this.codeFontSize;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TaskDetailSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_COMMENTS = "comments";
        private static final String PROPERTY_SLIDE_TITLE = "slideTitle";
        private static final String PROPERTY_SLIDE_CODE_SNIPPETS = "codeSnippets";
        @JsonProperty(value="slideTitle")
        private final String title;
        @JsonProperty(value="comments")
        private final List<SlideCommentRenderData> comments;
        @JsonProperty(value="codeSnippets")
        private final List<TaskDetailSlideCodeSnippet> codeSnippets;

        @JsonCreator
        public TaskDetailSlideResult(@JsonProperty(value="slideTitle") String title, @JsonProperty(value="codeSnippets") List<TaskDetailSlideCodeSnippet> codeSnippets, @JsonProperty(value="comments") List<SlideCommentRenderData> comments) {
            this.title = title;
            this.codeSnippets = codeSnippets;
            this.comments = comments;
        }

        public List<TaskDetailSlideCodeSnippet> getCodeSnippets() {
            return this.codeSnippets;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TaskDetailSlideCodeSnippet
    extends CodeSnippet {
        private static final long serialVersionUID = 1L;
        private static final String FINDINGS_PROPERTY = "findings";
        @JsonProperty(value="content")
        private final SelfContainedFinding.FindingContent content;
        @JsonProperty(value="findings")
        private final List<SelfContainedFinding> findings = new ArrayList<SelfContainedFinding>();

        @JsonCreator
        public TaskDetailSlideCodeSnippet(@JsonProperty(value="location") TextRegionLocation location, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="findingIds") List<String> findingIds, @JsonProperty(value="timeCreated") long timeCreated, @JsonProperty(value="shouldRenderFromFinding") boolean renderFromFinding, @JsonProperty(value="content") SelfContainedFinding.FindingContent content) {
            super(location, commit, findingIds, timeCreated, renderFromFinding);
            this.content = content;
        }

        public void addFinding(SelfContainedFinding finding) {
            this.findings.add(finding);
        }

        public List<SelfContainedFinding> getFindings() {
            return this.findings;
        }

        public String getTextContent() {
            return this.content.getText();
        }
    }
}

