/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.index.baseline.BaselineIndex;
import com.teamscale.index.query.ReplacePreprocessorBase;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

public class BaselinePreprocessor
extends ReplacePreprocessorBase {
    private static final String BASELINE_KEYWORD = "baseline";
    private final ProjectStorageSystem projectStorageSystem;

    public BaselinePreprocessor(ProjectStorageSystem projectStorageSystem) {
        this.projectStorageSystem = projectStorageSystem;
    }

    @Override
    protected String getKeyword() {
        return BASELINE_KEYWORD;
    }

    @Override
    protected int insertReplacement(int index, List<QueryToken> tokens, List<QueryToken> result, Set<String> encounteredValues) throws QueryParsingException, StorageException {
        String baselineName = BaselinePreprocessor.extractParameterName(tokens, index + 1, this.getKeyword());
        BaselineInfo baseline = this.getBaseline(baselineName);
        if (baseline == null) {
            throw new QueryParsingException("Baseline \"" + baselineName + "\" is not defined.", tokens);
        }
        result.add(new QueryToken(EQueryTokenType.LITERAL, DateTimeUtils.formatTimestamp((long)baseline.getTimestamp(), (DateTimeFormatter)DateTimeFormatter.ISO_LOCAL_DATE), (long)tokens.get(index).getPosition()));
        return 3;
    }

    private BaselineInfo getBaseline(String baseline) throws StorageException {
        BaselineIndex baselineIndex = (BaselineIndex)this.projectStorageSystem.openProjectIndex(BaselineIndex.class, null);
        return baselineIndex.getBaseline(baseline);
    }
}

