/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import com.teamscale.core.index.IndexCache;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.report.ParsedReportIndex;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.jspecify.annotations.Nullable;

public class ParsedReportIndexCache
extends IndexCache<String, ParsedReportIndex.ParsedReport, ParsedReportWithMap> {
    public ParsedReportIndexCache(ParsedReportIndex parsedReportIndex, long maxCacheSize, ByteUnit unit) {
        super(ParsedReportIndexCache.cacheWithMaxSize(maxCacheSize, unit), ParsedReportWithMap::from, key -> ParsedReportIndexCache.getParsedReport(parsedReportIndex, key), parsedReportIndex::getReports);
    }

    private static ParsedReportIndex.ParsedReport getParsedReport(ParsedReportIndex parsedReportIndex, String key) throws StorageException {
        return parsedReportIndex.getReports(List.of(key)).getFirst();
    }

    private static UnaryOperator<Caffeine<String, Optional<ParsedReportWithMap>>> cacheWithMaxSize(long maxSize, ByteUnit unit) {
        long maxBytes = unit.toBytes(maxSize);
        Weigher sizeWeigher = (key, value) -> value.map(ParsedReportIndexCache::getApproximateSizeBytes).orElse(0);
        return cache -> cache.weigher(sizeWeigher).maximumWeight(maxBytes).recordStats();
    }

    private static int getApproximateSizeBytes(ParsedReportWithMap parsedReport) {
        return (int)parsedReport.getEstimatedSizeBytes();
    }

    record ParsedReportWithMap(ParsedReportIndex.ParsedReport report, Map<String, List<ExternalAnalysisImportInfo<?>>> importInfosByUniformPath) {
        private static ParsedReportWithMap from(ParsedReportIndex.ParsedReport report) {
            Map<String, List<ExternalAnalysisImportInfo<?>>> importInfosByUniformPath = report.importInfos().getInfos().stream().collect(Collectors.groupingBy(ExternalAnalysisImportInfo::getUniformPath));
            return new ParsedReportWithMap(report, importInfosByUniformPath);
        }

        public long getEstimatedSizeBytes() {
            return this.report.importInfos().getEstimatedSizeBytes() + (long)this.report.importInfos().getInfos().size() * 22L;
        }

        public static @Nullable ParsedReportIndex.ParsedReport getReportOrNull(@Nullable ParsedReportWithMap reportMap) {
            if (reportMap == null) {
                return null;
            }
            return reportMap.report();
        }
    }
}

