/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.astree;

import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.report.astree.AstreeAlarmCategory;
import com.teamscale.index.report.astree.AstreeAlarmType;
import com.teamscale.index.report.astree.AstreeElementBase;
import com.teamscale.index.report.astree.AstreeReportHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.helpers.DefaultHandler;

public class AstreeReportToRulesConverter {
    public static void main(String[] args) throws Exception {
        String pathToReport = "inputReport.xml";
        String outputPath = "/tmp/rules.json";
        AstreeReportHandler handler = new AstreeReportHandler();
        XMLUtils.parseSAX((String)pathToReport, (DefaultHandler)handler);
        AstreeReportToRulesConverter.writeTeamscaleRules(handler, outputPath);
    }

    public static void writeTeamscaleRules(AstreeReportHandler handler, String outputPath) throws IOException, ConQATException {
        List<AstreeAlarmType> alarmTypes = handler.getAlarmTypes();
        List<AstreeAlarmCategory> alarmCategories = handler.getAlarmCategories();
        Map<String, AstreeAlarmCategory> idToCategoryMapping = alarmCategories.stream().collect(Collectors.toMap(AstreeElementBase::getId, category -> category));
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (AstreeAlarmType alarmType : alarmTypes) {
            Rule teamscaleRule = new Rule();
            teamscaleRule.id = alarmType.getId();
            teamscaleRule.description = alarmType.getName();
            teamscaleRule.message = alarmType.getName();
            teamscaleRule.category = idToCategoryMapping.get(alarmType.getCategoryId()).getName();
            teamscaleRule.type = alarmType.getId();
            rules.add(teamscaleRule);
        }
        String json = JsonUtils.serializeToJSONPrettyPrinted(rules);
        FileSystemUtils.writeFileUTF8((File)new File(outputPath), (String)json);
    }
}

