/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.base;

import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.string.LineOffsetConverter;

public abstract class OffsetConvertingFindingReportParserBase
extends FindingCollectingReportParserBase {
    private Map<String, LineOffsetConverter> lineOffsetConvertersByPath;

    @Override
    protected void resetState() {
        super.resetState();
        this.lineOffsetConvertersByPath = new HashMap<String, LineOffsetConverter>();
    }

    protected Optional<TextRegionLocation> createTextRegionLocation(String pathInTeamscale, int startLine, int startColumn, int endLine, int endColumn) throws StorageException {
        OptionalInt rawStartOffset = this.getRawOffsetInTeamscale(pathInTeamscale, startLine, startColumn);
        OptionalInt rawEndOffset = this.getRawOffsetInTeamscale(pathInTeamscale, endLine, endColumn);
        if (rawStartOffset.isPresent() && rawEndOffset.isPresent()) {
            return Optional.of(new TextRegionLocation(pathInTeamscale, rawStartOffset.getAsInt(), rawEndOffset.getAsInt(), startLine, endLine));
        }
        return Optional.empty();
    }

    private OptionalInt getRawOffsetInTeamscale(String pathInTeamscale, int lineNumber, int columnInLine) throws StorageException {
        LineOffsetConverter lineOffsetConverter;
        if (!this.lineOffsetConvertersByPath.containsKey(pathInTeamscale)) {
            TokenElementLineInfo info = this.tokenElementLineInfoIndex.getLineInfo(pathInTeamscale);
            this.lineOffsetConvertersByPath.put(pathInTeamscale, info.getRawLineOffsetConverter());
        }
        if (!(lineOffsetConverter = this.lineOffsetConvertersByPath.get(pathInTeamscale)).isValidLine(lineNumber)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(lineOffsetConverter.getOffset(lineNumber) + columnInLine - 1);
    }
}

