/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.ReportParserFactory;
import com.teamscale.index.report.coverage.CoverageReportParserInvokerBase;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.CoverageUnitContainer;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.RawTestwiseReport;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestInfo;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class RawTestwiseReportParser
extends CoverageReportParserInvokerBase {
    @Override
    protected void parseCoverageReport(String content, CoverageInfoRetriever coverageInfoRetriever) throws ReportParserException {
        RawTestwiseReport testwiseReport = !content.startsWith("{") ? this.decodeAndDecompress(content) : RawTestwiseReportParser.parseRawTestwiseReport(content);
        EReportFormat format = EReportFormat.valueOf(testwiseReport.format);
        IReportParser parser = ReportParserFactory.createParser(format);
        parser.init(this.basicTokenElementIndex, this.tokenElementIndexCache, this.tokenElementLineInfoIndex, this.binaryElementIndex, this.matchingPathsLookup, this.typeIndexCache, this.externalFindingsGroupDescriptionIndex, this.connectorId, this.projectMetaIndex, this.disablePlausibilityCheckForPathMapping, this.parallelExecutor, this.repository);
        for (TestInfo test : testwiseReport.tests) {
            ReportContentIndexBase.ReportContent report = new ReportContentIndexBase.ReportContent(format, -1L, StringUtils.stringToBytes((String)test.content), StandardCharsets.UTF_8, null, this.connectorId);
            List<ExternalAnalysisImportInfoLineCoverage> coverageInfos = this.parseSingleCoverageReport(report, parser);
            RawTestwiseReportParser.addSingleReportToTestwiseCoverage(coverageInfoRetriever, test, coverageInfos, testwiseReport.partial);
        }
    }

    /*
     * Exception decompiling
     */
    private RawTestwiseReport decodeAndDecompress(String content) throws ReportParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RawTestwiseReport parseRawTestwiseReport(String content) throws ReportParserException {
        try {
            RawTestwiseReport report = (RawTestwiseReport)JsonUtils.deserializeFromJson((String)content, RawTestwiseReport.class);
            if (report.format == null) {
                throw new ReportParserException("Property `format` must be set in the report.");
            }
            return report;
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    private static void addSingleReportToTestwiseCoverage(CoverageInfoRetriever coverageInfoRetriever, TestInfo test, List<ExternalAnalysisImportInfoLineCoverage> coverageInfos, boolean partial) {
        UniformPath uniformPath = TestUniformPathUtils.escapeAndConvertToTestExecutionUniformPath((String)test.uniformPath);
        RawTestwiseReportParser.createTestInfoContainer(coverageInfoRetriever, uniformPath, test, partial);
        CoverageUnitContainer coverageUnitContainer = coverageInfoRetriever.createCoverageUnitContainer(uniformPath.toString());
        coverageUnitContainer.setPartOfPartialReport(partial);
        MultiFileRangeCoverageInfo multiFileRange = coverageUnitContainer.getCoverageInfo();
        for (ExternalAnalysisImportInfoLineCoverage coverageInfo : coverageInfos) {
            RawTestwiseReportParser.writeLineCoverageToMultiFileRange(coverageInfo, multiFileRange);
        }
    }

    private static void createTestInfoContainer(CoverageInfoRetriever coverageInfoRetriever, UniformPath uniformPath, TestInfo test, boolean partial) {
        TestInfoContainer testInfoContainer = coverageInfoRetriever.createTestwiseCoverageInfo(uniformPath.toString());
        testInfoContainer.setDurationSeconds(test.duration);
        testInfoContainer.setResult(test.result);
        testInfoContainer.setMessage(test.message);
        testInfoContainer.setHash(test.hash);
        testInfoContainer.setProperties(test.properties);
        testInfoContainer.setExternalLink(test.externalLink);
        testInfoContainer.setPartOfPartialReport(partial);
    }

    private static void writeLineCoverageToMultiFileRange(ExternalAnalysisImportInfoLineCoverage coverageInfo, MultiFileRangeCoverageInfo multiFileRange) {
        CompactLines lineCoverage = coverageInfo.getData().getCoveredLines();
        multiFileRange.addLineCoverage(coverageInfo.getUniformPath(), lineCoverage);
        CompactLines coverableLines = coverageInfo.getData().getAllCoverableLines();
        multiFileRange.addCoverableLines(coverageInfo.getUniformPath(), coverableLines);
    }

    private List<ExternalAnalysisImportInfoLineCoverage> parseSingleCoverageReport(ReportContentIndexBase.ReportContent report, IReportParser parser) throws ReportParserException {
        parser.parse(report, null);
        ExternalAnalysisImportInfos importInfos = parser.getInfos();
        return importInfos.filterByType(ExternalAnalysisImportInfoLineCoverage.class);
    }
}

