/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.report.generic.ExternalFindingData;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.Arrays;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ExternalFindingFileData
implements IExternalUploadRequestPart {
    @JsonProperty(value="findings")
    private ExternalFindingData[] findings;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="content")
    private @Nullable String content;

    public ExternalFindingFileData(ExternalFindingData[] findings, String path) {
        this.findings = findings;
        this.path = path;
    }

    public ExternalFindingFileData() {
    }

    public void validate() throws ReportParserException {
        if (StringUtils.isEmpty((String)this.getPath())) {
            throw new ReportParserException("The finding path may not be empty/null!");
        }
        for (ExternalFindingData finding : this.getFindings()) {
            finding.validate();
        }
    }

    public ExternalFindingData[] getFindings() {
        if (this.findings == null) {
            return new ExternalFindingData[0];
        }
        return this.findings;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalFindingFileData that = (ExternalFindingFileData)o;
        return Arrays.equals(this.findings, that.findings) && this.path.equals(that.path) && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        int result = Objects.hash(this.path, this.content);
        result = 31 * result + Arrays.hashCode(this.findings);
        return result;
    }
}

