/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class CSCompilerWarningsLikeParserBase
extends FindingCollectingReportParserBase {
    final Pattern singleLineNumberWarning = Pattern.compile("(?:[\\d\\s\\.:]*\\d+>)?\\s*(.*)\\(([0-9]+)(?:,[0-9]+)?\\).*warning[:\\s]*(" + this.getWarningsTypePrefixPattern() + "\\w*):\\s?(.*?)\\s?(?:\\[([^\\[]*)\\]$)?");
    static final Pattern MS_BUILD_WARNING = Pattern.compile("MSBUILD : warning : (\\w*) : (.*)\\[(.*)\\]");
    private List<CSCompilerWarningLikeFinding> csCompilerWarningFindings;

    @Override
    protected void resetState() {
        super.resetState();
        this.csCompilerWarningFindings = new ArrayList<CSCompilerWarningLikeFinding>();
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) {
        new CSCompilerWarningsLikeAnalyzer().loadReport(report);
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (CSCompilerWarningLikeFinding compilerWarning : this.csCompilerWarningFindings) {
            String warningLocation = CSCompilerWarningsLikeParserBase.normalizeAndCleanPath(compilerWarning);
            Optional<String> uniformPath = this.resolvePath(warningLocation);
            if (uniformPath.isEmpty()) continue;
            DetachedFinding finding = CSCompilerWarningsLikeParserBase.createLineFinding(compilerWarning.lineNumber, uniformPath.get(), compilerWarning.ruleId, this.getInternalFindingsCategoryName(), compilerWarning.message);
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }

    private static String normalizeAndCleanPath(CSCompilerWarningLikeFinding compilerWarning) {
        String warningLocation = UniformPathUtils.normalizeAllSeparators((String)compilerWarning.location);
        warningLocation = UniformPathUtils.cleanPath((String)warningLocation);
        return warningLocation;
    }

    protected void createCSCompilerWarningFinding(String message, String location, String ruleId, int lineNumber) {
        this.csCompilerWarningFindings.add(new CSCompilerWarningLikeFinding(this, message, location, ruleId, lineNumber));
    }

    protected abstract String getInternalFindingsCategoryName();

    private String getWarningsTypePrefixPattern() {
        return "(?:" + this.getSupportedWarningsTypePrefixes().stream().collect(Collectors.joining("|")) + ")";
    }

    protected abstract Collection<String> getSupportedWarningsTypePrefixes();

    public class CSCompilerWarningsLikeAnalyzer {
        private void createSingleLineFindings(String line, Pattern pattern) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            String filename = matcher.group(1);
            int lineNum = Integer.parseInt(matcher.group(2));
            String ruleId = matcher.group(3);
            String message = matcher.group(4);
            String project = matcher.group(5);
            if (project != null) {
                boolean useBackslashSeparator = project.contains("\\");
                project = UniformPathUtils.normalizeAllSeparators((String)project);
                String projectPrefixedFilename = UniformPathUtils.resolveRelativePath((String)project, (String)filename);
                if (useBackslashSeparator) {
                    projectPrefixedFilename = projectPrefixedFilename.replace(UniformPathUtils.SEPARATOR, "\\");
                }
                CSCompilerWarningsLikeParserBase.this.createCSCompilerWarningFinding(message, projectPrefixedFilename, ruleId, lineNum);
            } else {
                CSCompilerWarningsLikeParserBase.this.createCSCompilerWarningFinding(message, filename, ruleId, lineNum);
            }
        }

        private void createWarningFinding(String line, Pattern warningPattern) {
            Matcher matcher = warningPattern.matcher(line);
            if (matcher.matches()) {
                String filename = matcher.group(3);
                String ruleId = matcher.group(1);
                String message = matcher.group(2);
                CSCompilerWarningsLikeParserBase.this.createCSCompilerWarningFinding(message, filename, ruleId, -1);
            }
        }

        public void loadReport(String report) {
            String[] lines;
            for (String line : lines = StringUtils.splitLines((String)report)) {
                this.createSingleLineFindings(line, CSCompilerWarningsLikeParserBase.this.singleLineNumberWarning);
                this.createWarningFinding(line, MS_BUILD_WARNING);
            }
        }
    }

    private class CSCompilerWarningLikeFinding {
        final String location;
        final String ruleId;
        final String message;
        final int lineNumber;

        public CSCompilerWarningLikeFinding(CSCompilerWarningsLikeParserBase cSCompilerWarningsLikeParserBase, String message, String location, String ruleId, int lineNumber) {
            this.location = location;
            this.ruleId = ruleId;
            this.message = message;
            this.lineNumber = lineNumber;
        }
    }
}

