/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.message.MypyMessageManager;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.MypyReportEntry;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class MypyReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<MypyReportEntry> reportEntries;

    @Override
    protected void resetState() {
        super.resetState();
        this.reportEntries = new ArrayList<MypyReportEntry>();
    }

    @Override
    protected void collectFindings() throws StorageException {
        MypyMessageManager messageManager = MypyMessageManager.getInstance();
        for (MypyReportEntry mypyReportEntry : this.reportEntries) {
            Optional<String> uniformPath = this.resolvePath(mypyReportEntry.path);
            if (uniformPath.isEmpty()) continue;
            String findingsGroupName = messageManager.getFindingsGroupNameFor(mypyReportEntry.errorCode);
            if (findingsGroupName == null) {
                LOGGER.warn("Unknown mypy error code: {}", (Object)mypyReportEntry.errorCode);
                continue;
            }
            DetachedFinding finding = MypyReportParser.createLineFinding(mypyReportEntry.line, uniformPath.get(), findingsGroupName, messageManager.getFindingCategoryName(), mypyReportEntry.message);
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        report.lines().forEach(line -> MypyReportEntry.createFromReportLine(line).ifPresent(this.reportEntries::add));
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        MypyReportParser.checkEnabledAnalysisTool(EAnalysisTool.MYPY, analysisProfiles, projectId);
    }
}

