/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultIssueLikeBase;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class ExternalAnalysisResultIssueLikeProcessorBase<I extends TeamscaleIssue, T extends ExternalAnalysisResultIssueLikeBase<I>>
extends ExternalAnalysisResultProcessorBase<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<I> issues = new ArrayList<I>();
    private String connectorId;

    @Override
    public boolean extract(String partition, UniformPath uniformPath, T analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        this.issues.addAll((Collection)((ExternalAnalysisResult)analysisResult).getData());
        this.connectorId = ((ExternalAnalysisResultIssueLikeBase)analysisResult).getConnectorId();
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        if (this.issues.isEmpty()) {
            return;
        }
        OptionalLong lastChangeTimestamp = this.getIssueIndex().getLastChange(this.connectorId);
        if (lastChangeTimestamp.isPresent() && lastChangeTimestamp.getAsLong() >= commit.getTimestamp()) {
            return;
        }
        this.checkForDuplicates(this.issues);
        Map<TeamscaleIssueId, I> changedIssues = this.addNewOrChangedIssues(this.issues);
        this.addClosedIssues(changedIssues, this.issues, commit);
        this.setUpdated(changedIssues, commit);
        this.getIssueIndex().setIssues(changedIssues.values());
        this.getIssueHistoryIndex().store(this.getIssueHistoryPairList(changedIssues.values()));
        this.getIssueIndex().setLastChange(this.connectorId, this.getLastChangeTimeStamp(changedIssues.values()));
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
    }

    @Override
    public void reset() {
        this.issues.clear();
        this.connectorId = null;
    }

    protected abstract IssueIndexBase<I> getIssueIndex();

    protected abstract IIssueHistoryIndex<I> getIssueHistoryIndex();

    private long getLastChangeTimeStamp(Collection<I> issues) {
        OptionalLong max = issues.stream().mapToLong(TeamscaleIssue::getUpdated).max();
        if (max.isPresent()) {
            return max.getAsLong();
        }
        return 0L;
    }

    private void checkForDuplicates(List<I> issues) {
        List keys = CollectionUtils.map(issues, TeamscaleIssue::getId);
        Set duplicates = CollectionUtils.getDuplicates((List)keys);
        if (!duplicates.isEmpty()) {
            LOGGER.warn("Following issue ids occur more than once: " + String.valueOf(duplicates));
        }
    }

    private void addClosedIssues(Map<TeamscaleIssueId, I> issueMap, List<I> allIssues, CommitDescriptor commit) throws StorageException {
        HashSet<TeamscaleIssueId> deletedOrClosed = new HashSet<TeamscaleIssueId>(this.getIssueIndex().getAllKeysForConnector(this.connectorId));
        deletedOrClosed.removeAll(CollectionUtils.mapToSet(allIssues, TeamscaleIssue::getId));
        for (TeamscaleIssueId key : deletedOrClosed) {
            I issue = this.getIssueIndex().getIssue(key);
            if (issue.isClosed()) continue;
            issue.setClosed(true);
            issue.setUpdated(commit.getTimestamp());
            issueMap.put(key, issue);
        }
    }

    private void setUpdated(Map<TeamscaleIssueId, I> changedIssues, CommitDescriptor commit) {
        for (TeamscaleIssue issue : changedIssues.values()) {
            if (issue.getUpdated() != -1L) continue;
            issue.setUpdated(commit.getTimestamp());
        }
    }

    private PairList<Long, I> getIssueHistoryPairList(Collection<I> issues) {
        PairList pairList = new PairList();
        for (TeamscaleIssue issue : issues) {
            pairList.add((Object)issue.getUpdated(), (Object)issue);
        }
        return pairList;
    }

    private Map<TeamscaleIssueId, I> addNewOrChangedIssues(List<I> issues) throws StorageException {
        HashMap<TeamscaleIssueId, TeamscaleIssue> issuesMap = new HashMap<TeamscaleIssueId, TeamscaleIssue>();
        for (TeamscaleIssue issue : issues) {
            issuesMap.put(issue.getId(), issue);
        }
        Set<TeamscaleIssueId> changedKeys = this.getIssueIndex().getContainedKeys(new ArrayList<TeamscaleIssueId>(issuesMap.keySet()));
        for (TeamscaleIssueId key : changedKeys) {
            I oldIssue = this.getIssueIndex().getIssue(key);
            TeamscaleIssue newIssue = (TeamscaleIssue)issuesMap.get(key);
            if (newIssue.getUpdated() == -1L) {
                oldIssue.setUpdated(newIssue.getUpdated());
            }
            if (!newIssue.equals(oldIssue)) continue;
            issuesMap.remove(key);
        }
        return issuesMap;
    }
}

