/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndexBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="project-repositorychanges", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={RepositoryChangeEntry.class, ProjectRepositoryStatus.class})
public class ProjectRepositoryChangeIndex
extends RepositoryChangeIndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "project-repositorychanges";
    private static final String RETRIEVAL_STATUS_KEY = "retrieval-status";
    private static final String LIVE_BRANCHES_KEY_PREFIX = "live-branches:";

    public ProjectRepositoryChangeIndex(IStore store) {
        super(store);
    }

    public ProjectRepositoryStatus getRepositoryStatus() throws StorageException {
        ProjectRepositoryStatus repositoryStatus = (ProjectRepositoryStatus)StorageUtils.deserialize((byte[])this.store.getWithString(RETRIEVAL_STATUS_KEY));
        if (repositoryStatus == null) {
            return new ProjectRepositoryStatus("unknown");
        }
        return repositoryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeCommitTree(CommitTree commitTree, String defaultBranchName, String connectionIdentifier) throws StorageException {
        Lock lock = this.store.obtainLock("merge-commit-tree");
        lock.lock();
        try {
            ProjectRepositoryStatus repositoryStatus = (ProjectRepositoryStatus)StorageUtils.deserialize((byte[])this.store.getWithString(RETRIEVAL_STATUS_KEY));
            if (repositoryStatus == null) {
                repositoryStatus = new ProjectRepositoryStatus(defaultBranchName);
            }
            HashSet<String> nonEmptyBranchNames = new HashSet<String>(commitTree.getAllKnownBranchNames());
            repositoryStatus.mergeIn(commitTree);
            repositoryStatus.setLiveBranchNames(this.updateAndDetermineLiveBranches(commitTree, connectionIdentifier));
            repositoryStatus.setBranchesWithCommits(nonEmptyBranchNames);
            this.store.putWithString(RETRIEVAL_STATUS_KEY, StorageUtils.serialize((Serializable)repositoryStatus));
        }
        finally {
            lock.unlock();
        }
    }

    private Set<String> updateAndDetermineLiveBranches(CommitTree commitTree, String connectionIdentifier) throws StorageException {
        this.store.putWithString(LIVE_BRANCHES_KEY_PREFIX + connectionIdentifier, StorageUtils.serialize(new ArrayList(CollectionUtils.sort((Collection)commitTree.getLiveBranchNames()))));
        final HashSet<String> liveBranches = new HashSet<String>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                liveBranches.addAll(StorageUtils.deserializeStringList((byte[])value));
            }
        };
        this.store.scan(LIVE_BRANCHES_KEY_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return liveBranches;
    }

    @IndexValueClass
    public static class ProjectRepositoryStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String defaultBranchName;
        private final Set<String> branchNames = new HashSet<String>();
        private Set<String> liveBranchNames = new HashSet<String>();
        private Set<String> branchesWithCommits = new HashSet<String>();

        public ProjectRepositoryStatus(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
        }

        public void mergeIn(CommitTree commitTree) {
            this.branchNames.addAll(commitTree.getKnownBranchNames());
        }

        public String getDefaultBranchName() {
            return this.defaultBranchName;
        }

        public Set<String> getBranchNames() {
            return this.branchNames;
        }

        public Set<String> getLiveBranchNames() {
            return this.liveBranchNames;
        }

        public Set<String> getBranchesWithCommits() {
            return this.branchesWithCommits;
        }

        private void setLiveBranchNames(Set<String> liveBranchNames) {
            this.liveBranchNames = liveBranchNames;
        }

        private void setBranchesWithCommits(Set<String> branchesWithCommits) {
            this.branchesWithCommits = branchesWithCommits;
        }

        public Set<String> getNonPrecommitBranchNames() {
            return CollectionUtils.filterToSet(this.branchNames, name -> !PreCommitUtils.isPrecommitBranch((String)name));
        }
    }
}

