/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import java.io.Serializable;
import java.util.StringJoiner;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class RepositoryLogFileChurn
extends CommitAssociatedObjectBase
implements Serializable {
    private static final String NUM_ADDED_FILES_PROPERTY = "numAddedFiles";
    private static final String NUM_CHANGED_FILES_PROPERTY = "numChangedFiles";
    private static final String NUM_DELETED_FILES_PROPERTY = "numDeletedFiles";
    private static final String NUM_MOVED_FILES_PROPERTY = "numMovedFiles";
    private static final String NUM_COPIED_FILES_PROPERTY = "numCopiedFiles";
    private static final long serialVersionUID = 0L;
    @JsonProperty(value="numAddedFiles")
    private final int numAddedFiles;
    @JsonProperty(value="numChangedFiles")
    private final int numChangedFiles;
    @JsonProperty(value="numDeletedFiles")
    private final int numDeletedFiles;
    @JsonProperty(value="numMovedFiles")
    private final int numMovedFiles;
    @JsonProperty(value="numCopiedFiles")
    private final int numCopiedFiles;

    @JsonCreator
    public RepositoryLogFileChurn(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="numAddedFiles") int numAddedFiles, @JsonProperty(value="numChangedFiles") int numChangedFiles, @JsonProperty(value="numDeletedFiles") int numDeletedFiles, @JsonProperty(value="numMovedFiles") int numMovedFiles, @JsonProperty(value="numCopiedFiles") int numCopiedFiles) {
        super(commit);
        this.numAddedFiles = numAddedFiles;
        this.numChangedFiles = numChangedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.numMovedFiles = numMovedFiles;
        this.numCopiedFiles = numCopiedFiles;
    }

    public int getNumAddedFiles() {
        return this.numAddedFiles;
    }

    public int getNumChangedFiles() {
        return this.numChangedFiles;
    }

    public int getNumDeletedFiles() {
        return this.numDeletedFiles;
    }

    public int getNumMovedFiles() {
        return this.numMovedFiles;
    }

    public int getNumCopiedFiles() {
        return this.numCopiedFiles;
    }

    public static RepositoryLogFileChurn aggregate(CommitDescriptor commit, PairList<String, ElementHistoryEntry> values) {
        int numAdded = 0;
        int numChanged = 0;
        int numDeleted = 0;
        int numMoved = 0;
        int numCopied = 0;
        block8: for (ElementHistoryEntry entry : values.getSecondList()) {
            switch (entry.getChangeType()) {
                case ADD: {
                    ++numAdded;
                    continue block8;
                }
                case EDIT: {
                    ++numChanged;
                    continue block8;
                }
                case DELETE: {
                    ++numDeleted;
                    continue block8;
                }
                case MOVE: {
                    ++numMoved;
                    continue block8;
                }
                case COPY: {
                    ++numCopied;
                    continue block8;
                }
                case EXTERNAL_ANALYSIS_UPLOAD: {
                    continue block8;
                }
            }
            throw new AssertionError((Object)("Unknown repository change type: " + String.valueOf((Object)entry.getChangeType())));
        }
        return new RepositoryLogFileChurn(commit, numAdded, numChanged, numDeleted - numMoved, numMoved, numCopied);
    }

    public String toString() {
        StringJoiner files = new StringJoiner(", ");
        if (this.numAddedFiles > 0) {
            files.add(this.numAddedFiles + " added");
        }
        if (this.numChangedFiles > 0) {
            files.add(this.numChangedFiles + " changed");
        }
        if (this.numDeletedFiles > 0) {
            files.add(this.numDeletedFiles + " deleted");
        }
        if (this.numCopiedFiles > 0) {
            files.add(this.numCopiedFiles + " copied");
        }
        if (this.numMovedFiles > 0) {
            files.add(this.numMovedFiles + " moved");
        }
        return files.toString();
    }
}

