/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@Index(name="revisions", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMMIT_ISOLATED}, valueClasses={String.class, CommitDescriptor.class})
public class RepositoryRevisionIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "revisions";
    private static final String KNOWN_REPOSITORY_COMMITS_PARTITION_NAME = "all_revisions_partition";
    private static final String PROCESSED_COMMITS_PARTITION_NAME = "processed_revisions_partition";
    private static final String REVISION_REPOSITORY_SEPARATOR = "~";
    private final ConvenientStore knownRepositoryCommitsStore;
    private final ConvenientStore processedCommitsStore;

    public RepositoryRevisionIndex(IStore store) {
        this.processedCommitsStore = new ConvenientStore((IStore)new DelegatingPartitionStore(store, PROCESSED_COMMITS_PARTITION_NAME), false);
        this.knownRepositoryCommitsStore = new ConvenientStore((IStore)new DelegatingPartitionStore(store, KNOWN_REPOSITORY_COMMITS_PARTITION_NAME), false);
    }

    public void setKnownRepositoryCommits(PairList<RevisionAndRepository, CommitDescriptor> values) throws StorageException {
        RepositoryRevisionIndex.writeValuesToStore(values, this.knownRepositoryCommitsStore);
    }

    public void setProcessedCommits(PairList<RevisionAndRepository, CommitDescriptor> values) throws StorageException {
        RepositoryRevisionIndex.writeValuesToStore(values, this.processedCommitsStore);
    }

    private static void writeValuesToStore(PairList<RevisionAndRepository, CommitDescriptor> values, ConvenientStore store) throws StorageException {
        PairList valuesToStore = new PairList();
        for (int i = 0; i < values.size(); ++i) {
            valuesToStore.add((Object)RepositoryRevisionIndex.createKey((RevisionAndRepository)values.getFirst(i)), (Object)StorageUtils.serialize((Serializable)((Serializable)values.getSecond(i))));
        }
        store.putWithStrings(valuesToStore);
    }

    public void setProcessedCommit(RevisionAndRepository revisionAndRepository, CommitDescriptor commitDescriptor) throws StorageException {
        this.processedCommitsStore.putWithString(RepositoryRevisionIndex.createKey(revisionAndRepository), StorageUtils.serialize((Serializable)commitDescriptor));
    }

    public void setKnownRepositoryCommit(RevisionAndRepository revisionAndRepository, CommitDescriptor commitDescriptor) throws StorageException {
        this.knownRepositoryCommitsStore.putWithString(RepositoryRevisionIndex.createKey(revisionAndRepository), StorageUtils.serialize((Serializable)commitDescriptor));
    }

    private static String createKey(RevisionAndRepository revisionAndRepository) {
        return revisionAndRepository.revision() + REVISION_REPOSITORY_SEPARATOR + revisionAndRepository.repositoryIdentifier();
    }

    public PairList<CommitDescriptor, RevisionAndRepository> getProcessedCommits(String revision) throws StorageException {
        return RepositoryRevisionIndex.getCommitsFromStore(revision, this.processedCommitsStore);
    }

    public PairList<CommitDescriptor, RevisionAndRepository> getKnownRepositoryCommits(String revision) throws StorageException {
        return RepositoryRevisionIndex.getCommitsFromStore(revision, this.knownRepositoryCommitsStore);
    }

    private static PairList<CommitDescriptor, RevisionAndRepository> getCommitsFromStore(String revision, ConvenientStore store) throws StorageException {
        PairList result = new PairList();
        ExceptionHandlingKeyValueCallback callback = new ExceptionHandlingKeyValueCallback((PairList<CommitDescriptor, RevisionAndRepository>)result);
        store.scan(revision, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        PairList exactMatches = result.filter((commit, revisionAndResult) -> revisionAndResult.revision().equals(revision));
        if (!exactMatches.isEmpty()) {
            return exactMatches;
        }
        return result;
    }

    public Optional<CommitDescriptor> getFirstKnownRepositoryCommit(String revision) throws StorageException {
        return this.getKnownRepositoryCommits(revision).extractFirstList().stream().sorted().findFirst();
    }

    public Optional<CommitDescriptor> getFirstProcessedCommit(String revision) throws StorageException {
        return this.getProcessedCommits(revision).extractFirstList().stream().sorted().findFirst();
    }

    public PairList<CommitDescriptor, RevisionAndRepository> getAllProcessedRevisions() throws StorageException {
        return RepositoryRevisionIndex.getAllRevisionsFromStore(this.processedCommitsStore);
    }

    public PairList<CommitDescriptor, RevisionAndRepository> getAllKnownRepositoryRevisions() throws StorageException {
        return RepositoryRevisionIndex.getAllRevisionsFromStore(this.knownRepositoryCommitsStore);
    }

    private static PairList<CommitDescriptor, RevisionAndRepository> getAllRevisionsFromStore(ConvenientStore store) throws StorageException {
        PairList result = new PairList();
        ExceptionHandlingKeyValueCallback callback = new ExceptionHandlingKeyValueCallback((PairList<CommitDescriptor, RevisionAndRepository>)result);
        store.scan("", (IKeyValueCallback)callback);
        return result;
    }

    public void removeRevisions(Collection<String> revisions) throws StorageException {
        for (String revision : revisions) {
            String revisionPrefix = revision + REVISION_REPOSITORY_SEPARATOR;
            this.processedCommitsStore.removeByPrefix(revisionPrefix);
            this.knownRepositoryCommitsStore.removeByPrefix(revisionPrefix);
        }
    }

    public record RevisionAndRepository(String revision, String repositoryIdentifier) {
    }

    @ThreadSafe
    private static class ExceptionHandlingKeyValueCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final PairList<CommitDescriptor, RevisionAndRepository> result;

        private ExceptionHandlingKeyValueCallback(PairList<CommitDescriptor, RevisionAndRepository> result) {
            this.result = result;
        }

        protected synchronized void callbackWithException(byte[] key, byte[] value) throws StorageException {
            String keyAsString = StringUtils.bytesToString((byte[])key);
            CommitDescriptor commit = (CommitDescriptor)StorageUtils.deserialize((byte[])value);
            String[] splitKey = keyAsString.split(RepositoryRevisionIndex.REVISION_REPOSITORY_SEPARATOR, 2);
            String fullRevision = splitKey[0];
            String repositoryIdentifier = splitKey[1];
            this.result.add((Object)commit, (Object)new RevisionAndRepository(fullRevision, repositoryIdentifier));
        }
    }
}

