/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RevisionResolverFactory;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import com.teamscale.index.testimpact.CommitAndRevision;
import jakarta.ws.rs.NotFoundException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class RevisionResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final InternalProjectId projectId;
    private final @Nullable String userName;

    private RevisionResolver(IndexLayer indexLayer, InternalProjectId projectId, @Nullable String userName) {
        this.indexLayer = indexLayer;
        this.projectId = projectId;
        this.userName = userName;
    }

    public static CommitDescriptor resolveRevisionOrCommit(CommitAndRevision commitAndRevision, String userName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        if (!StringUtils.isEmpty((String)commitAndRevision.revision())) {
            return new RevisionResolver(indexLayer, projectId, userName).resolveRevision(commitAndRevision.revision(), commitAndRevision.repository()).orElseThrow(() -> RevisionResolver.createNotFoundException(commitAndRevision));
        }
        return UnresolvedCommitDescriptorUtils.resolveCommitWithFallbackTimestamp((UnresolvedCommitDescriptor)commitAndRevision.commit(), (long)DateTimeUtils.millisNow(), () -> indexLayer.openProjectStorageSystem((IProjectId)projectId));
    }

    public static Optional<Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>> resolveRevisionAndRepository(String revision, @Nullable String repositoryName, @Nullable String userName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        return Optional.ofNullable(new RevisionResolver(indexLayer, projectId, userName).resolveRevisionToCommit(revision, repositoryName));
    }

    private static NotFoundException createNotFoundException(CommitAndRevision commitAndRevision) {
        String message = StringUtils.isEmpty((String)commitAndRevision.repository()) ? "Revision " + commitAndRevision.revision() + " not found in Teamscale and neither in any of the available VCS repositories." : "Revision " + commitAndRevision.revision() + " not found in Teamscale and also in VCS repository identified in Teamscale as: " + commitAndRevision.repository();
        return new NotFoundException(message);
    }

    public Optional<CommitDescriptor> resolveRevision(String revision, @Nullable String repositoryName) throws StorageException {
        Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolvedCommit = this.resolveRevisionToCommit(revision, repositoryName);
        if (resolvedCommit == null) {
            return Optional.empty();
        }
        return Optional.of((CommitDescriptor)resolvedCommit.getFirst());
    }

    private @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionToCommit(String revision, @Nullable String repositoryName) throws StorageException {
        Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolvedCommit = this.resolveRevisionWithRepositoryRevisionIndex(revision, repositoryName);
        if (resolvedCommit != null) {
            return resolvedCommit;
        }
        return this.resolveRevisionFromRepository(revision, repositoryName);
    }

    private @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionWithRepositoryRevisionIndex(String revision, @Nullable String repository) throws StorageException {
        PairList possibleRevisions = ((RepositoryRevisionIndex)this.indexLayer.openProjectIndex((IProjectId)this.projectId, RepositoryRevisionIndex.class, null)).getProcessedCommits(revision);
        int numberOfPossibleCommits = (possibleRevisions = possibleRevisions.removeIf((commit, revisionAndRepository) -> RevisionResolver.isExternalStorageBackendRevision(revisionAndRepository))).size();
        if (numberOfPossibleCommits == 0) {
            LOGGER.warn("Revision {} not found in repository revision index.", (Object)revision);
            return null;
        }
        if (numberOfPossibleCommits == 1) {
            return (Pair)possibleRevisions.toList().getFirst();
        }
        if (repository == null) {
            LOGGER.warn("Commits present in multiple repositories but no repository specified for revision '{}': {}", (Object)revision, (Object)possibleRevisions);
            return null;
        }
        for (Pair possibleRevision : possibleRevisions) {
            if (!((RepositoryRevisionIndex.RevisionAndRepository)possibleRevision.getSecond()).repositoryIdentifier().equals(repository)) continue;
            return possibleRevision;
        }
        LOGGER.warn("Revision {} not found for repository {}", (Object)revision, (Object)repository);
        return null;
    }

    private @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionFromRepository(String revision, @Nullable String repositoryName) throws StorageException {
        if (StringUtils.isEmpty((String)repositoryName)) {
            LOGGER.info("Revision {} not found in Teamscale. Resolving revision from all available VCS repositories.", (Object)revision);
        } else {
            LOGGER.info("Revision {} not found in Teamscale. Resolving revision from VCS repository identified in Teamscale as {}", (Object)revision, (Object)repositoryName);
        }
        for (ConnectorConfiguration connector : this.getProjectConfiguration().getConnectors()) {
            CommitDescriptor resolvedCommit;
            String repositoryIdentifier = connector.getIdentifier();
            if (!StringUtils.isEmpty((String)repositoryName) && !repositoryName.equals(repositoryIdentifier) || (resolvedCommit = this.resolveRevisionFromConnector(revision, connector)) == null) continue;
            this.saveResolvedCommitToIndex(revision, repositoryIdentifier, resolvedCommit);
            LOGGER.info("Revision {} successfully resolved to {}", (Object)revision, (Object)resolvedCommit.toServiceCallFormat());
            return new Pair((Object)resolvedCommit, (Object)new RepositoryRevisionIndex.RevisionAndRepository(revision, connector.getIdentifier()));
        }
        return null;
    }

    private @Nullable CommitDescriptor resolveRevisionFromConnector(String revision, ConnectorConfiguration connectorConfiguration) throws StorageException {
        ConnectorDescriptorBase connectorDescriptor = this.loadConnector(this.projectId, connectorConfiguration);
        if (!(connectorDescriptor instanceof RepositoryConnectorDescriptorBase)) {
            return null;
        }
        RepositoryConnectorDescriptorBase repositoryConnectorDescriptor = (RepositoryConnectorDescriptorBase)connectorDescriptor;
        return this.tryResolveCommit(revision, repositoryConnectorDescriptor);
    }

    private @Nullable ConnectorDescriptorBase loadConnector(InternalProjectId project, ConnectorConfiguration connector) throws StorageException {
        try {
            return ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.userName, this.indexLayer, (IExternalCredentialsProvider)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER), (InternalProjectId)project);
        }
        catch (ProjectConfigurationException e) {
            LOGGER.warn("Failed to load connector {} during external upload.", (Object)connector.getIdentifier());
            return null;
        }
    }

    private @Nullable CommitDescriptor tryResolveCommit(String revision, RepositoryConnectorDescriptorBase connectorDescriptor) throws StorageException {
        Optional<IRevisionResolver> revisionResolver = RevisionResolverFactory.getRevisionResolver(connectorDescriptor, this.projectId, this.indexLayer);
        if (revisionResolver.isEmpty()) {
            return null;
        }
        return revisionResolver.get().resolveToCommitDescriptor(revision).orElse(null);
    }

    private void saveResolvedCommitToIndex(String revision, String repositoryIdentifier, CommitDescriptor commitDescriptor) throws StorageException {
        ((RepositoryRevisionIndex)this.indexLayer.openProjectIndex((IProjectId)this.projectId, RepositoryRevisionIndex.class, null)).setProcessedCommit(new RepositoryRevisionIndex.RevisionAndRepository(revision, repositoryIdentifier), commitDescriptor);
    }

    private static boolean isExternalStorageBackendRevision(RepositoryRevisionIndex.RevisionAndRepository revisionAndRepository) {
        return "external-analysis-data".equals(revisionAndRepository.repositoryIdentifier());
    }

    private ProjectConfiguration getProjectConfiguration() throws StorageException {
        return Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.projectId, (IndexLayer)this.indexLayer), "Project configuration not found in project ID '%s'".formatted(this.projectId));
    }
}

