/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class ArtifactStoreCommitResolutionCacheIndexBase
implements IProjectIndexWithDynamicName {
    private final ValueIndex<CommitDescriptor> delegate;
    private String indexInstanceName;

    protected ArtifactStoreCommitResolutionCacheIndexBase(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public CommitDescriptor getCommit(String foreignRepositoryId, String revision, String branchName) throws StorageException {
        return (CommitDescriptor)this.delegate.getValue(ArtifactStoreCommitResolutionCacheIndexBase.createKey(foreignRepositoryId, revision, branchName));
    }

    public void storeCommit(String foreignRepositoryId, String revision, String branchName, CommitDescriptor commit) throws StorageException {
        this.delegate.setValue(ArtifactStoreCommitResolutionCacheIndexBase.createKey(foreignRepositoryId, revision, branchName), (Object)commit);
    }

    private static String createKey(String foreignRepositoryId, String revision, String branchName) {
        StringBuilder key = new StringBuilder();
        if (!StringUtils.isEmpty((String)foreignRepositoryId)) {
            key.append(foreignRepositoryId).append("-");
        }
        key.append(branchName).append("@").append(revision);
        return key.toString();
    }

    public void setName(String indexInstanceName) {
        this.indexInstanceName = indexInstanceName;
    }

    public String getName() {
        return this.indexInstanceName;
    }
}

