/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import com.teamscale.index.repository.artifact_store.LatestArchivesOnBranchCollector;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.s3.S3ArtifactStore;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.s3.CredentialsProcess;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class ArtifactStoreUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T extends ArtifactStoreRepositoryInfoBase> Collection<String> fetchFilesFromArtifactStore(@Nullable ProjectConfiguration projectConfiguration, ConnectorConfiguration connectorConfiguration, T info, SimpleArtifactStoreClientBase<T> client) throws RepositoryException, ProjectConfigurationException {
        if (projectConfiguration != null) {
            info.setProjectConfiguration(projectConfiguration);
        }
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        ItemQueryResultData archiveFiles = ArtifactStoreUtils.findItems(client, info);
        List<ArtifactStoreItemData> filteredItemData = info.getKeyIncludeExcludePatterns().filterArtifacts(archiveFiles.results);
        return LatestArchivesOnBranchCollector.collect(connectorConfiguration.getIdentifier(), filteredItemData, info, defaultBranchName, LOGGER);
    }

    private static <T extends ArtifactStoreRepositoryInfoBase> ItemQueryResultData findItems(SimpleArtifactStoreClientBase<T> client, T info) throws RepositoryException, ProjectConfigurationException {
        try {
            return client.findItems(info, 0);
        }
        catch (RescheduleRequestedException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public static S3RepositoryInfo createS3RepositoryInfo(ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        return ArtifactStoreUtils.initializeRepositoryInfoForPreview(S3RepositoryInfo::new, info -> info.setUseCredentialsProcess(connectorConfiguration), connectorConfiguration, foreignCommitTreeIndex);
    }

    public static ArtifactoryRepositoryInfo createArtifactoryRepositoryInfo(ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        return ArtifactStoreUtils.initializeRepositoryInfoForPreview(ArtifactoryRepositoryInfo::new, connectorConfiguration, foreignCommitTreeIndex);
    }

    private static <R extends ArtifactStoreRepositoryInfoBase> R initializeRepositoryInfoForPreview(Supplier<R> createInfo, ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        return (R)ArtifactStoreUtils.initializeRepositoryInfoForPreview(createInfo, info -> {}, connectorConfiguration, foreignCommitTreeIndex);
    }

    private static <R extends ArtifactStoreRepositoryInfoBase> R initializeRepositoryInfoForPreview(Supplier<R> createInfo, Consumer<R> prepareInfo, ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        ArtifactStoreRepositoryInfoBase info = (ArtifactStoreRepositoryInfoBase)createInfo.get();
        prepareInfo.accept(info);
        info.setRepositoryOrBucketName(connectorConfiguration);
        info.setBranchExtractionPattern(connectorConfiguration.getOptionValue("Branch Extraction Pattern"));
        info.setRawRevisionResolvers(ArtifactStoreRepositoryConnectorDescriptorBase.createCompoundCommitResolverDescriptor(connectorConfiguration));
        info.setPrefixExtractionPattern(connectorConfiguration.getOptionValue("Prefix Extraction Pattern"));
        info.setIsExternalStorage(Optional.ofNullable(connectorConfiguration.getOptionValue("Is External Storage")).map(Boolean::parseBoolean).orElse(false));
        info.setIncludeAndExcludePatterns(connectorConfiguration);
        info.setAllowExtractionFailures(true);
        info.setForeignCommitTreeIndex(foreignCommitTreeIndex);
        info.initializeInMemoryIndexes();
        return (R)info;
    }

    public static SimpleArtifactStoreClientBase<?> getClientForProtocol(ExternalStorageBackend externalStorageBackend, ExternalCredentials credentials, IndexLayer indexLayer) throws StorageException, ProjectConfigurationException {
        switch (externalStorageBackend.backendProtocol()) {
            default: {
                throw new MatchException(null, null);
            }
            case S3: 
        }
        return S3ArtifactStore.createS3ArtifactStore(credentials, ArtifactStoreUtils.getCredentialsProcess(externalStorageBackend, indexLayer));
    }

    private static @Nullable CredentialsProcess getCredentialsProcess(ExternalStorageBackend externalStorageBackend, IndexLayer indexLayer) throws StorageException, ProjectConfigurationException {
        if (!externalStorageBackend.useS3CredentialsProcess()) {
            return null;
        }
        return CredentialsProcess.readFromServerOptions((ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class));
    }

    private ArtifactStoreUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

