/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.external_storage;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsProviderRegistry;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationHooks;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.external_storage.ExternalStorageConstants;
import com.teamscale.index.repository.artifact_store.revision_interpretation.CompoundCommitResolverDescriptor;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionInterpretationFactory;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryConnectorDescriptor;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.ExternalStorageProjectMappingId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class S3ExternalStorageConfigurator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID PROJECT_CONFIGURATOR_UUID = UUID.fromString("3358c022-5ed0-4ba0-9b0a-576e72dd141b");
    private final S3ExternalStorageConnectorDescriptor descriptor = new S3ExternalStorageConnectorDescriptor();

    private S3ExternalStorageConfigurator() {
    }

    static void registerProjectConfigurationHooks() {
        ProjectConfigurationHooks.getInstance().registerConfigurator(PROJECT_CONFIGURATOR_UUID, S3ExternalStorageConfigurator::configureProject);
        if (EFeatureToggle.OVERWRITE_EXTERNAL_STORAGE.isEnabled()) {
            ExternalCredentialsProviderRegistry.getInstance().registerProvider(S3ExternalStorageConfigurator.createCredentialsOverwriteProvider());
        }
    }

    private static void configureProject(ProjectCreationProxy proxy, ConfigurationInitializationContext context, boolean validateProject) throws ProjectConfigurationException {
        new S3ExternalStorageConfigurator().configureExternalStorageConnection(proxy, context, validateProject);
    }

    private void configureExternalStorageConnection(ProjectCreationProxy proxy, ConfigurationInitializationContext context, boolean validateProject) throws ProjectConfigurationException {
        Optional<ExternalStorageBackend> externalStorageBackend = S3ExternalStorageConfigurator.readExternalStorageBackend(proxy, context);
        if (externalStorageBackend.isEmpty()) {
            return;
        }
        this.descriptor.setProjectId(proxy.getInternalId());
        this.descriptor.init(context);
        this.descriptor.setGeneratedOptions(proxy, externalStorageBackend.get());
        if (validateProject) {
            S3ExternalStorageConfigurator.validateRepositoryIdentifierIsUnused(proxy, this.descriptor.getRepositoryIdentifier());
            this.descriptor.validate();
        }
        this.descriptor.configureProject(proxy);
    }

    private static void validateRepositoryIdentifierIsUnused(ProjectCreationProxy proxy, String repositoryIdentifier) throws ConnectorValidationException {
        if (proxy.getNewProjectConfiguration().getConnectors().stream().map(ConnectorConfiguration::getIdentifier).anyMatch(repositoryIdentifier::equals)) {
            throw new ConnectorValidationException("Repository identifier '%s' is reserved for external storage. Please choose another identifier.".formatted("external-analysis-data"));
        }
    }

    private static Optional<ExternalStorageBackend> readExternalStorageBackend(ProjectCreationProxy proxy, ConfigurationInitializationContext context) throws ProjectConfigurationException {
        try {
            return ExternalStorageLookup.getStorageBackend(proxy.getNewProjectConfiguration().getInternalId(), proxy.getNewProjectConfiguration().getExternalStorageBackend(), (ExternalStorageBackendIndex)context.getGlobalStorageSystem().openGlobalIndex(ExternalStorageBackendIndex.class));
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    private static IExternalCredentialsProvider createCredentialsOverwriteProvider() {
        return credentialsName -> {
            if (!"##external-storage-overwrite##".equals(credentialsName)) {
                return null;
            }
            String overwriteUri = (String)TeamscaleSystemProperties.OVERWRITE_EXTERNAL_STORAGE_URI.getValue().orElseThrow(() -> new IllegalStateException("Attempted to load credentials for overwrite even though no overwrite URI was provided"));
            return new ExternalCredentials("##external-storage-overwrite##", overwriteUri);
        };
    }

    public static S3RepositoryInfo getGeneratedRepositoryInfo(InternalProjectId internalProjectId, ExternalStorageProjectMappingId externalStorageProjectMappingId, ConfigurationInitializationContext context, ExternalStorageBackend externalStorageBackend) {
        S3ExternalStorageConfigurator configurator = new S3ExternalStorageConfigurator();
        configurator.descriptor.init(context);
        configurator.descriptor.setGeneratedOptions(internalProjectId, externalStorageProjectMappingId, externalStorageBackend);
        ConnectorConfiguration connector = new ConnectorConfiguration(ERepositoryConnector.S3.getReadableName(), "Repository identifier");
        connector.setOptionsFromDescriptor((ConnectorDescriptorBase)configurator.descriptor);
        return ArtifactStoreUtils.createS3RepositoryInfo(connector, null);
    }

    private static final class S3ExternalStorageConnectorDescriptor
    extends S3RepositoryConnectorDescriptor {
        private static final String TIMESTAMP_AS_UNIX_EPOCH_INTERPRETATION = ERevisionInterpretationFactory.TIMESTAMP.name() + ":millis";
        private static final String DEFAULT_BRANCH_UNUSED = "##UNUSED##";
        private static final String REVISION_INTERPRETATION = ERevisionInterpretationFactory.CONNECTOR.name();

        private S3ExternalStorageConnectorDescriptor() {
        }

        @Override
        protected PairList<String, String> reportMappingDefaultValue() {
            PairList reportMappings = new PairList();
            for (EReportFormat reportFormat : EReportFormat.values()) {
                reportMappings.add((Object)("**.zip/" + reportFormat.name() + "/**"), (Object)reportFormat.toString());
            }
            return reportMappings;
        }

        @Override
        protected void validateHttpConnection(URI uri) {
        }

        public void setGeneratedOptions(ProjectCreationProxy proxy, ExternalStorageBackend externalStorage) {
            this.setGeneratedOptions(proxy.getInternalId(), proxy.getExternalId(), externalStorage);
        }

        private void setGeneratedOptions(InternalProjectId internalProjectId, ExternalStorageProjectMappingId externalStorageProjectMappingId, ExternalStorageBackend externalStorage) {
            LOGGER.traceEntry("Configuring external storage for project '{}'.", new Object[]{internalProjectId});
            this.isExternalStorage = true;
            this.repositoryIdentifier = "external-analysis-data";
            this.accountIdentifier = new AccountCredentials(externalStorage.credentialsName());
            this.codeIncludePatterns.clear();
            this.codeIncludePatterns.add("**");
            this.defaultBranchName = DEFAULT_BRANCH_UNUSED;
            this.ignoreChangesOlderThanDays = null;
            this.partitionPattern = ExternalStorageConstants.PARTITION_EXTRACTION_PATTERN;
            this.prefixExtractionPattern = "(.*)";
            this.branchExtractionPattern = ExternalStorageConstants.BRANCH_EXTRACTION_PATTERN;
            this.repositoryExtractionPattern = "";
            this.compoundCommitResolverDescriptor = new CompoundCommitResolverDescriptor((Pair<String, String>)Pair.createPair((Object)ExternalStorageConstants.REVISION_EXTRACTION_PATTERN, (Object)REVISION_INTERPRETATION), Pair.createPair((Object)ExternalStorageConstants.TIMESTAMP_EXTRACTION_PATTERN, (Object)TIMESTAMP_AS_UNIX_EPOCH_INTERPRETATION));
            this.pollingIntervalSeconds = 86400;
            this.bucketName = externalStorage.repositoryOrBucketName();
            this.useCredentialsProcess = externalStorage.useS3CredentialsProcess();
            this.keyPrefixes.clear();
            this.keyPrefixes.add(S3ExternalStorageConnectorDescriptor.createKeyPrefix(externalStorageProjectMappingId, externalStorage.uploadPathPrefix()));
            this.deletePartitionsWithoutNewUploads = EFeatureToggle.ENABLE_DELETE_PARTITIONS_WITHOUT_UPLOADS_FOR_EXTERNAL_STORAGE.isEnabled();
            this.includedKeyPatterns.clear();
            this.codeExcludePatterns.clear();
            this.excludedKeyPatterns.clear();
            this.excludedKeyPatterns.add(S3ExternalStorageConnectorDescriptor.getMetadataKeyPattern(externalStorageProjectMappingId, externalStorage));
            this.excludedKeyPatterns.add(S3ExternalStorageConnectorDescriptor.getArchiveKeyPattern(externalStorageProjectMappingId, externalStorage));
            LOGGER.debug("Initialized S3 external storage with options:\n{}", new Supplier[]{() -> ((S3ExternalStorageConnectorDescriptor)this).getAllOptions()});
        }

        private static String getMetadataKeyPattern(ExternalStorageProjectMappingId externalStorageProjectMappingId, ExternalStorageBackend externalStorage) {
            return StringUtils.ensureEndsWith((String)S3ExternalStorageConnectorDescriptor.createKeyPrefix(externalStorageProjectMappingId, externalStorage.uploadPathPrefix() + "__metadata__"), (String)"/") + "**";
        }

        private static String getArchiveKeyPattern(ExternalStorageProjectMappingId externalStorageProjectMappingId, ExternalStorageBackend externalStorage) {
            return StringUtils.ensureEndsWith((String)S3ExternalStorageConnectorDescriptor.createKeyPrefix(externalStorageProjectMappingId, externalStorage.uploadPathPrefix() + "__archive__"), (String)"/") + "**";
        }

        private static String createKeyPrefix(ExternalStorageProjectMappingId externalStorageProjectMappingId, String uploadPathPrefix) {
            String externalProjectId = externalStorageProjectMappingId.toString();
            if (StringUtils.isEmpty((String)uploadPathPrefix)) {
                return externalProjectId;
            }
            return StringUtils.ensureEndsWith((String)uploadPathPrefix, (String)"/") + externalProjectId;
        }
    }
}

