/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem.multiversion;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemCommit;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemRepositoryConnectorDescriptor;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MultiVersionFileSystemBranchRetriever
implements IBranchRetriever {
    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        String inputDirectory = connectorConfiguration.getOptionValue("Input directory");
        List<String> directoryNames = MultiVersionFileSystemRepositoryConnectorDescriptor.getRevisionDirectoryNames(new File(inputDirectory));
        if (directoryNames.isEmpty()) {
            return new HashSet<String>();
        }
        List allCommits = CollectionUtils.mapWithException(directoryNames, name -> new MultiVersionFileSystemCommit((String)name, defaultBranchName));
        return allCommits.stream().map(MultiVersionFileSystemCommit::getBranchName).collect(Collectors.toSet());
    }
}

