/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitGraphNode
extends CommitGraphNode {
    @JsonProperty(value="commit")
    private final RevCommit commit;
    private Long cachedCommitTimestamp = null;
    private String cachedCommitMessage = null;

    public GitCommitGraphNode(RevCommit commit) {
        super(commit.getName());
        this.commit = commit;
    }

    @Override
    public long getCommitTimestamp() {
        if (this.cachedCommitTimestamp == null) {
            this.cachedCommitTimestamp = GitUtils.extractLocalCommitTime(this.commit);
        }
        return this.cachedCommitTimestamp;
    }

    @Override
    public String getCommitMessage() {
        if (this.cachedCommitMessage == null) {
            this.cachedCommitMessage = this.commit.getFullMessage();
        }
        return this.cachedCommitMessage;
    }

    @Override
    public void resolve(Map<String, CommitGraphNode> nodesByName) {
        if (this.commit.getParents() == null) {
            return;
        }
        for (RevCommit parent : this.commit.getParents()) {
            CommitGraphNode parentNode = nodesByName.get(parent.getName());
            if (parentNode == null) continue;
            this.parents.add(parentNode);
            parentNode.successors.add(this);
        }
    }

    @Override
    public AnyObjectId getCommitId() {
        return this.commit.getId();
    }

    @Override
    public RevCommit getCommit() {
        return this.commit;
    }

    @Override
    public String toString() {
        return "GitCommitGraphNode [commit=" + String.valueOf(this.commit) + ", branchName=" + this.branchName + ", parents=" + this.parents.stream().map(commit -> commit.getCommit().getName()).collect(Collectors.joining()) + "]";
    }
}

