/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.git.GitCommitGraphNode;
import com.teamscale.index.repository.git.GitLfsClient;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitSubModuleRepository;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.GitWriteLockManager;
import com.teamscale.index.repository.git.ISubModuleRegistry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class GitRepositoryBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String GIT_CONFIGURATION_PARAMETER_URL = "url";
    private static final String GIT_CONFIGURATION_SUBSECTION_ORIGIN = "origin";
    private static final String GIT_CONFIGURATION_SECTION_REMOTE = "remote";
    private static final Pattern MISSING_REF_PATTERN = Pattern.compile("Remote does not have (.*) available for fetch.");
    private static final Set<String> RESERVED_WINDOWS_PATH_SEGMENT_NAMES = new CaseInsensitiveStringSet(Arrays.asList("CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    protected final GitRepositoryConnection connection;
    protected final URI location;
    protected final EGitProtocol protocol;
    protected final Repository repository;
    private final ISubModuleRegistry subModuleRegistry;
    private final ICancelable cancelable;

    protected GitRepositoryBase(GitRepositoryConnection connection, URI location, ICancelable cancelable) throws RepositoryException {
        this.connection = connection;
        this.location = location;
        this.cancelable = cancelable;
        this.subModuleRegistry = this.createSubModuleRegistry();
        this.protocol = (EGitProtocol)EnumUtils.valueOfIgnoreCase(EGitProtocol.class, (String)location.getScheme());
        if (this.protocol == null) {
            throw new RepositoryException("No/unsupported protocol in repository location: " + String.valueOf(location));
        }
        this.repository = this.setUp();
    }

    protected GitRepositoryBase(GitRepositoryConnection connection) {
        this.connection = connection;
        this.protocol = null;
        this.location = null;
        this.cancelable = null;
        this.subModuleRegistry = null;
        this.repository = null;
    }

    protected abstract ISubModuleRegistry createSubModuleRegistry();

    public Optional<GitSubModuleRepository> createSubModule(String url, Supplier<String> messageContextSupplier) {
        try {
            URI submoduleUrl = GitRepositoryBase.buildSubModuleUrl(url, this.location.toString());
            GitSubModuleRepository repository = new GitSubModuleRepository(this.connection, submoduleUrl, this.cancelable);
            repository.synchronize();
            return Optional.of(repository);
        }
        catch (URISyntaxException | RepositoryException e) {
            LOGGER.error("Could not open submodule for URL '" + url + "': " + e.getMessage() + "\nContext: " + messageContextSupplier.get(), e);
            return Optional.empty();
        }
    }

    static URI buildSubModuleUrl(String submoduleUrl, String parentLocation) throws URISyntaxException, RepositoryException {
        EGitProtocol submoduleProtocol;
        Optional protocol = EGitProtocol.fromUri((String)submoduleUrl);
        if (protocol.isEmpty()) {
            String baseLocation = StringUtils.ensureEndsWith((String)parentLocation, (String)"/");
            return new URI(baseLocation + submoduleUrl).normalize();
        }
        EGitProtocol parentProtocol = (EGitProtocol)EGitProtocol.fromUri((String)parentLocation).orElseThrow();
        if (parentProtocol == (submoduleProtocol = (EGitProtocol)protocol.get()) || parentProtocol == EGitProtocol.FILE) {
            return new URI(submoduleUrl);
        }
        if (submoduleProtocol == EGitProtocol.FILE) {
            throw new RepositoryException("May not switch to file protocol in submodules of non file repositories!");
        }
        if (!submoduleUrl.toLowerCase().startsWith(submoduleProtocol.getUrlPrefix())) {
            return new URI(submoduleUrl);
        }
        if (submoduleProtocol == EGitProtocol.SSH) {
            return new URI(submoduleUrl);
        }
        return new URI(parentProtocol.getUrlPrefix() + submoduleUrl.substring(submoduleProtocol.getUrlPrefix().length()));
    }

    public URI getLocation() {
        return this.location;
    }

    public EGitProtocol getProtocol() {
        return this.protocol;
    }

    public GitRepositoryConnection getConnection() {
        return this.connection;
    }

    private Repository setUp() throws RepositoryException {
        return switch (this.protocol) {
            case EGitProtocol.FILE -> GitUtils.getExistingLocalRepository(this.getLocalDirectory().toUri());
            case EGitProtocol.HTTP, EGitProtocol.HTTPS, EGitProtocol.SSH -> GitUtils.cloneAndSetUpRepository(this.getLocalDirectory(), this.location, this.connection.getCredentials(), this.cancelable, this.getDefaultBranchNameForSetup());
            default -> throw new RepositoryException("Unknown/unsupported protocol for git connector: " + String.valueOf(this.protocol));
        };
    }

    protected @Nullable String getDefaultBranchNameForSetup() {
        return this.connection.getDefaultBranchName();
    }

    public static Path getLocalCloneLocation(Path cloneDirectory, URI location, boolean isGerrit, @Nullable Long gerritMinimumCreationTimestamp) {
        if (EnumUtils.valueOfIgnoreCase(EGitProtocol.class, (String)location.getScheme()) == EGitProtocol.FILE) {
            return Paths.get(location);
        }
        String cleanPath = StringUtils.stripPrefix((String)location.getPath(), (String)"/").replaceAll("[^-_a-zA-Z0-9.]", "-");
        String encodedLocation = Digester.createMD5Digest((String)location.toString());
        Object extension = ".git";
        if (isGerrit) {
            extension = ".gerrit";
        }
        if (gerritMinimumCreationTimestamp != null) {
            CCSMAssert.isTrue((boolean)isGerrit, (String)"Minimum creation timestamp only supported for gerrit!");
            extension = "." + gerritMinimumCreationTimestamp + (String)extension;
        }
        return GitRepositoryBase.escapeReservedWindowsPathSegments(cloneDirectory.resolve(cleanPath + "-" + encodedLocation + (String)extension).toAbsolutePath());
    }

    @VisibleForTesting
    static Path escapeReservedWindowsPathSegments(Path path) {
        if (!SystemUtils.isWindows()) {
            return path;
        }
        Path escapedPath = path.getRoot();
        for (Path element : path) {
            Object elementName = element.toString();
            if (RESERVED_WINDOWS_PATH_SEGMENT_NAMES.contains(elementName)) {
                elementName = "_" + (String)elementName;
            }
            if (escapedPath == null) {
                escapedPath = Paths.get((String)elementName, new String[0]);
                continue;
            }
            escapedPath = escapedPath.resolve((String)elementName);
        }
        return escapedPath;
    }

    public Path getLocalDirectory() {
        return GitRepositoryBase.getLocalCloneLocation(this.connection.getCloneDirectory(), this.location, this.connection.isGerritConnection(), this.connection.getGerritMinimalCreationTimestamp());
    }

    public void initAndSynchronizeSubModules(Collection<String> revisions, int recursionDepth) throws RepositoryException {
        this.subModuleRegistry.initAndSynchronizeSubModules(revisions, recursionDepth);
    }

    public void synchronize() throws RepositoryException {
        this.synchronize(Collections.emptySet());
    }

    public void synchronize(Set<RefSpec> refSpecs) throws RepositoryException {
        if (!this.hasRemoteConfiguration()) {
            return;
        }
        try (GitWriteLockManager.GitDirectoryLock autoReleaseLock = GitWriteLockManager.lockGitRepositoryForWriting(this.repository);){
            Instant start = Instant.now();
            HashSet<TrackingRefUpdate> updatedRefs = new HashSet<TrackingRefUpdate>();
            if (!refSpecs.isEmpty()) {
                LOGGER.debug(() -> "Fetching " + refSpecs.size() + " ref specs: " + String.valueOf(refSpecs));
                updatedRefs.addAll(this.fetchRefs(refSpecs));
            }
            FetchResult fetchResult = this.createFetchCommand(this.cancelable).setTagOpt(TagOpt.FETCH_TAGS).call();
            updatedRefs.addAll(fetchResult.getTrackingRefUpdates());
            Instant end = Instant.now();
            LOGGER.info("Fetching all additional refSpecs took: {} ms", new org.apache.logging.log4j.util.Supplier[]{() -> ChronoUnit.MILLIS.between(start, end)});
            if (!updatedRefs.isEmpty()) {
                LOGGER.trace("Updated Refs: \n{}", new org.apache.logging.log4j.util.Supplier[]{() -> updatedRefs.stream().map(TrackingRefUpdate::toString).collect(Collectors.joining("\n"))});
                this.runNativeFetchIfNecessary(updatedRefs);
                this.handleUpdate();
            }
            this.validateDefaultBranchName(fetchResult);
        }
        catch (IOException | ParseException | StorageException | GitAPIException e) {
            throw new RepositoryException("Could not synchronize repository: " + e.getMessage(), e);
        }
    }

    private void runNativeFetchIfNecessary(Collection<TrackingRefUpdate> updatedRefs) throws IOException {
        Collection<TrackingRefUpdate> failedUpdates = GitRepositoryBase.collectFailedRefUpdates(this.repository, updatedRefs);
        if (failedUpdates.isEmpty()) {
            LOGGER.trace("No failed updates detected. Skipping native fetch.");
            return;
        }
        try {
            LOGGER.debug("Running native fetch to fix failed update(s).");
            GitUtils.runNativeGitCommand(this.getRepository(), Duration.ofMinutes(1L), "fetch", ".");
        }
        catch (Exception e) {
            LOGGER.error("Native fetch failed.", (Throwable)e);
        }
        failedUpdates = GitRepositoryBase.collectFailedRefUpdates(this.repository, failedUpdates);
        if (failedUpdates.isEmpty()) {
            LOGGER.trace("Successfully fixed failed ref update(s).");
            return;
        }
        LOGGER.error("Failed to update {} git ref(s) in '{}'. This may cause the repository to not receive any updates anymore. Failed updates: [{}].", (Object)failedUpdates.size(), (Object)this.repository.getDirectory(), (Object)failedUpdates.stream().map(TrackingRefUpdate::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
    }

    private Collection<TrackingRefUpdate> fetchRefs(Set<RefSpec> refSpecs) throws GitAPIException {
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
        supplierArray[0] = refSpecs::size;
        supplierArray[1] = () -> refSpecs.stream().map(RefSpec::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(","));
        LOGGER.debug("Fetching {} ref specs: {}", supplierArray);
        if (refSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        FetchCommand fetchCommand = this.createFetchCommand(this.cancelable);
        ArrayList<TrackingRefUpdate> updatedRefs = new ArrayList<TrackingRefUpdate>();
        ArrayList<RefSpec> specList = new ArrayList<RefSpec>(this.connection.filterIgnoredRefSpecs(refSpecs));
        for (int i = 0; i < specList.size(); i += 100) {
            List<RefSpec> subList = specList.subList(i, Math.min(i + 100, specList.size()));
            updatedRefs.addAll(this.callFetch(fetchCommand, subList));
        }
        return updatedRefs;
    }

    private Collection<TrackingRefUpdate> callFetch(FetchCommand fetchCommand, Collection<RefSpec> refs) throws GitAPIException {
        if (refs.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return fetchCommand.setRefSpecs(new ArrayList<RefSpec>(refs)).call().getTrackingRefUpdates();
        }
        catch (GitAPIException e) {
            return this.callFetch(fetchCommand, this.filterMissingRef(refs, e));
        }
    }

    @VisibleForTesting
    Collection<RefSpec> filterMissingRef(Collection<RefSpec> refs, GitAPIException gitException) throws GitAPIException {
        Matcher matcher = MISSING_REF_PATTERN.matcher(gitException.getMessage());
        if (!matcher.find()) {
            throw gitException;
        }
        String missingRef = matcher.group(1);
        List<RefSpec> filteredRefs = refs.stream().filter(refSpec -> {
            boolean matches = refSpec.matchSource(missingRef);
            if (matches) {
                try {
                    this.connection.storeFailedFetch(refSpec.getSource());
                }
                catch (StorageException storageException) {
                    LOGGER.warn("Failed to store missing ref count for '{}'.", (Object)refSpec.getSource(), (Object)storageException);
                }
            }
            return !matches;
        }).toList();
        if (filteredRefs.size() == refs.size()) {
            LOGGER.error("Failed to remove missing ref '{}' from ref specs [{}].", (Object)missingRef, (Object)refs.stream().map(RefSpec::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
        }
        LOGGER.warn("Ignoring missing ref '{}'.", (Object)missingRef);
        return filteredRefs;
    }

    private static Collection<TrackingRefUpdate> collectFailedRefUpdates(Repository repository, Collection<TrackingRefUpdate> updatedRefs) throws IOException {
        LOGGER.trace("Collecting failed ref updates for {} updated ref(s) in repository '{}'.", (Object)updatedRefs.size(), (Object)repository.getDirectory());
        Map existingUpdatedRefs = repository.getRefDatabase().exactRef(CollectionUtils.map(updatedRefs, TrackingRefUpdate::getLocalName).toArray(new String[0]));
        ArrayList<TrackingRefUpdate> failedUpdates = new ArrayList<TrackingRefUpdate>();
        for (TrackingRefUpdate updatedRef : updatedRefs) {
            Ref ref;
            if (updatedRef.asReceiveCommand().getType() == ReceiveCommand.Type.DELETE || (ref = (Ref)existingUpdatedRefs.getOrDefault(updatedRef.getLocalName(), null)) != null && ref.getObjectId().equals((AnyObjectId)updatedRef.getNewObjectId())) continue;
            failedUpdates.add(updatedRef);
        }
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[3];
        supplierArray[0] = failedUpdates::size;
        supplierArray[1] = () -> ((Repository)repository).getDirectory();
        supplierArray[2] = () -> failedUpdates.stream().map(TrackingRefUpdate::toString).collect(Collectors.joining("\n"));
        LOGGER.trace("Found {} failed ref update(s) in repository '{}':\n{}", supplierArray);
        return failedUpdates;
    }

    private void handleUpdate() throws StorageException, IOException, ParseException {
        this.setCommitTreeExpansionIfNecessary();
        this.connection.requestGarbageCollection();
    }

    private void setCommitTreeExpansionIfNecessary() throws StorageException {
        if (this.connection.gitParameters.getGitInfoIndex() != null) {
            this.connection.gitParameters.getGitInfoIndex().setCommitTreeExpansionNeeded(true);
        }
    }

    protected void validateDefaultBranchName(FetchResult fetchResult) throws RepositoryException {
        String defaultBranchName = this.connection.getDefaultBranchName();
        if (fetchResult.getAdvertisedRefs().stream().noneMatch(ref -> GitUtils.getBranchNameFromRef(ref).map(branchName -> branchName.equals(defaultBranchName)).orElse(false))) {
            String errorMessage = "Default branch " + defaultBranchName + " does not exist in this repository.";
            if (this.connection.isBranchingEnabled()) {
                LOGGER.warn(errorMessage);
                return;
            }
            throw new RepositoryException("Aborting analysis. " + errorMessage);
        }
    }

    private FetchCommand createFetchCommand(ICancelable cancelable) {
        return GitUtils.createFetchCommand(this.createGit(), this.getLocation(), this.connection.getCredentials(), cancelable);
    }

    public boolean hasRemoteConfiguration() {
        if (this.protocol == EGitProtocol.FILE) {
            return false;
        }
        String remoteUrl = this.repository.getConfig().getString(GIT_CONFIGURATION_SECTION_REMOTE, GIT_CONFIGURATION_SUBSECTION_ORIGIN, GIT_CONFIGURATION_PARAMETER_URL);
        return remoteUrl != null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Git createGit() {
        return new Git(this.repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Ref> getAllBranches(boolean filter) throws RepositoryException {
        try (Git git = this.createGit();){
            List branches = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            if (!filter) {
                List list2 = branches;
                return list2;
            }
            List<Ref> list = this.filterBranches(branches);
            return list;
        }
        catch (GitAPIException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected List<Ref> filterBranches(List<Ref> branches) throws RepositoryException {
        ArrayList<Ref> filteredBranches = new ArrayList<Ref>(branches.size());
        for (Ref branchRef : branches) {
            if (!GitRepositoryBase.isDefaultBranchName(branchRef, this.getConnection()) && !this.branchReferencesCommitAfterStartTimestamp(branchRef)) continue;
            filteredBranches.add(branchRef);
        }
        return filteredBranches;
    }

    private static boolean isDefaultBranchName(Ref branch, GitRepositoryConnection connection) {
        return connection.getDefaultBranchName().equals(GitUtils.getBranchNameFromRef(branch).orElse(""));
    }

    private boolean branchReferencesCommitAfterStartTimestamp(Ref branchRef) throws RepositoryException {
        Long newestCommitOnBranchTimestamp = this.getNewestCommitTimestamp(branchRef);
        return newestCommitOnBranchTimestamp >= this.connection.getAnalysisStart().toEpochMilli();
    }

    protected Long getNewestCommitTimestamp(Ref branchRef) throws RepositoryException {
        String commitId = branchRef.getObjectId().getName();
        return GitUtils.getTimestampFromRevision(this.repository, commitId).orElseThrow(() -> new RepositoryException("Could not find a revision " + commitId + " that clearly should exist for branch " + branchRef.getName()));
    }

    public Collection<Ref> getChangeRefs() throws RepositoryException {
        try {
            return this.getRepository().getRefDatabase().getRefsByPrefix("refs/changes/");
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Iterable<RevCommit> getAllCommits() throws RepositoryException {
        Iterable iterable;
        block9: {
            Git git = this.createGit();
            try {
                iterable = git.log().all().call();
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoHeadException e) {
                    throw new RepositoryException("A previous clone may have failed. Please clean the working directory: " + String.valueOf(this.getLocalDirectory()), (Throwable)e);
                }
                catch (IOException | GitAPIException e) {
                    throw new RepositoryException(e);
                }
            }
            git.close();
        }
        return iterable;
    }

    public RevCommit getCommit(String revision) throws RepositoryException {
        return GitUtils.getCommit(this.repository, revision);
    }

    public Optional<RevCommit> getOptionalCommit(String revision) {
        try {
            return Optional.of(this.getCommit(revision));
        }
        catch (RepositoryException e) {
            return Optional.empty();
        }
    }

    public Optional<String> getTextContent(RevCommit commit, String path) throws RepositoryException {
        Optional<byte[]> raw = this.getBinaryContent(commit, path);
        if (raw.isEmpty()) {
            return Optional.empty();
        }
        String textContent = new String(raw.get(), StandardCharsets.UTF_8);
        return Optional.of(textContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<byte[]> getBinaryContent(RevCommit commit, String path) throws RepositoryException {
        RevTree tree = commit.getTree();
        long objectSize = 0L;
        try (TreeWalk treewalk = TreeWalk.forPath((Repository)this.repository, (String)path, (RevTree)tree);){
            if (treewalk == null) {
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            ObjectId objectId = treewalk.getObjectId(0);
            ObjectLoader objectLoader = this.repository.open((AnyObjectId)objectId);
            objectSize = objectLoader.getSize();
            if (objectSize > 0x7FFFFFF7L) {
                LOGGER.error("Encountered large object (" + FileUtils.byteCountToDisplaySize((long)objectSize) + ") that exceeds the size of a Java array (2 GB), returning dummy content. Exclude this file: " + path);
                Optional<byte[]> optional = Optional.of(StringUtils.stringToBytes((String)"This file is too big to retrieve from Git, it should probably be excluded."));
                return optional;
            }
            byte[] bytes = objectLoader.getBytes();
            if (this.connection.gitParameters.isIncludeGitLfs()) {
                bytes = this.downloadLfsObject(bytes, objectSize);
            }
            Optional<byte[]> optional = Optional.of(bytes);
            return optional;
        }
        catch (MissingObjectException e1) {
            return Optional.empty();
        }
        catch (LargeObjectException e) {
            LOGGER.error("Encountered large object (" + FileUtils.byteCountToDisplaySize((long)objectSize) + "), returning dummy content. Either adjust the JVM flag 'com.teamscale.git-largefile-threshold-mb' or ignore this file: " + path, (Throwable)e);
            return Optional.of(StringUtils.stringToBytes((String)"This file is too big to retrieve from Git, it should probably be excluded."));
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load content for path '" + path + "' in commit '" + String.valueOf(commit) + "'", (Throwable)e);
        }
    }

    private byte[] downloadLfsObject(byte[] bytes, long objectSize) throws IOException, RepositoryException {
        byte[] byArray;
        Map<String, String> pointer = GitLfsClient.getLfsPointer(bytes, objectSize);
        if (pointer == null) {
            return bytes;
        }
        GitLfsClient client = new GitLfsClient(this.location, this.connection.getCredentials().getUsername(this.location), this.connection.getCredentials().getPassword(this.location));
        try {
            byArray = client.downloadFromLfs(pointer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RepositoryException("A queried Git LFS file was not found on the corresponding server.", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        client.close();
        return byArray;
    }

    public Optional<ObjectId> getId(RevCommit commit, String path) throws RepositoryException {
        return GitUtils.getId(this.repository, commit, path);
    }

    public Set<String> crawl(RevCommit commit, String basePath, int recursionDepth) throws RepositoryException {
        HashSet<String> hashSet;
        block9: {
            TreeWalk treeWalk = GitUtils.createTreeWalk(this.repository);
            try {
                HashSet<String> paths = new HashSet<String>();
                treeWalk.addTree((AnyObjectId)commit.getTree());
                while (treeWalk.next()) {
                    String newPath = basePath + treeWalk.getPathString();
                    if (!GitUtils.isActualFile(treeWalk.getRawMode(0)) || !this.connection.isIncluded(newPath)) continue;
                    paths.add(newPath);
                }
                paths.addAll(this.subModuleRegistry.crawl(commit, basePath, recursionDepth));
                hashSet = paths;
                if (treeWalk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (treeWalk != null) {
                        try {
                            treeWalk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            treeWalk.close();
        }
        return hashSet;
    }

    public Optional<byte[]> getContent(String path, String revision, int recursionDepth) throws RepositoryException {
        RevCommit commit = this.getCommit(revision);
        Optional<byte[]> fileContent = this.getBinaryContent(commit, path);
        if (fileContent.isPresent()) {
            return fileContent;
        }
        return this.subModuleRegistry.getContent(path, commit, recursionDepth);
    }

    public void createChangeEntries(RevCommit commit, RevCommit parentCommit, RepositoryChangeSet changeSet, String branchName, String basePath, int recursionDepth) throws RepositoryException {
        DiffFormatter diffFormatter = GitUtils.createDiffFormatter(this.repository);
        try {
            List diffs = diffFormatter.scan(parentCommit.getTree(), commit.getTree());
            for (DiffEntry diff : diffs) {
                this.createChangeFromDiffEntry(diff, parentCommit, changeSet, branchName, basePath);
            }
            this.subModuleRegistry.createChangeEntries(commit, parentCommit, changeSet, branchName, basePath, recursionDepth);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static String sanitizeGitPath(String path) {
        return path.replace('\u00b0', '/');
    }

    private void createChangeFromDiffEntry(DiffEntry diff, RevCommit parentCommit, RepositoryChangeSet changeSet, String branchName, String basePath) throws RepositoryException {
        Optional<DiffEntry.ChangeType> changeType = GitUtils.determineChangeType(diff);
        if (changeType.isEmpty()) {
            return;
        }
        Optional<String> originPath = GitRepositoryBase.prependBasePath(GitRepositoryBase.sanitizeGitPath(diff.getOldPath()), basePath);
        Optional<String> newPath = GitRepositoryBase.prependBasePath(GitRepositoryBase.sanitizeGitPath(diff.getNewPath()), basePath);
        if (changeType.get() == DiffEntry.ChangeType.DELETE) {
            originPath.ifPresent(s -> changeSet.addChange((String)s, ERepositoryChangeType.DELETE));
        } else if (newPath.isPresent()) {
            Optional<Object> originCommit = Optional.empty();
            switch (changeType.get()) {
                case MODIFY: {
                    changeSet.addChange(newPath.get(), ERepositoryChangeType.EDIT);
                    break;
                }
                case RENAME: {
                    changeSet.addChange(originPath.orElse(null), ERepositoryChangeType.DELETE);
                }
                case COPY: {
                    originCommit = this.getOriginCommit(parentCommit, branchName);
                }
                case ADD: {
                    changeSet.addChange(newPath.get(), ERepositoryChangeType.ADD, originPath.orElse(null), originCommit.orElse(null));
                    break;
                }
                default: {
                    throw new RepositoryException("Unexpected change type: " + String.valueOf(changeType.get()));
                }
            }
        }
    }

    private Optional<CommitDescriptor> getOriginCommit(RevCommit parentCommit, String branchName) {
        long originTimestamp = new GitCommitGraphNode(parentCommit).getCommitTimestamp();
        if (originTimestamp >= this.connection.getAnalysisStart().toEpochMilli()) {
            return Optional.of(new CommitDescriptor(branchName, originTimestamp));
        }
        return Optional.empty();
    }

    private static Optional<String> prependBasePath(String path, String basePath) {
        if (path == null) {
            return Optional.empty();
        }
        return Optional.of(basePath + path);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GitRepositoryBase) {
            GitRepositoryBase other = (GitRepositoryBase)obj;
            return this.location.equals(other.location);
        }
        return false;
    }

    public void close() {
        if (this.repository != null) {
            this.repository.close();
        }
    }
}

