/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.ISubscriptionRestClient;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitChangeEntryDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDescriptionDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestStatusDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestThreadDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitRepositoryDto;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitThreadCommentDto;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class AzureDevOpsGitClient {
    private final TfsHttpConnection clientWithProjectInUrl;
    private final TfsHttpConnection clientWithoutProjectInUrl;
    private final String projectName;
    private final String repositoryName;
    private final Logger interactionLogger;

    public <T extends Exception> AzureDevOpsGitClient(ExternalCredentials credentials, String repositoryName, Function<String, T> exceptionFactory, Logger interactionLogger) throws T {
        this(credentials.uri, credentials.username, credentials.password, repositoryName, exceptionFactory, interactionLogger);
    }

    public <T extends Exception> AzureDevOpsGitClient(String url, String username, String password, String repositoryName, Function<String, T> exceptionFactory, Logger interactionLogger) throws T {
        this(url, username, password, repositoryName, HttpRequestRetryPolicy.AZURE_DEVOPS, exceptionFactory, interactionLogger);
    }

    @TestOnly
    public <T extends Exception> AzureDevOpsGitClient(ExternalCredentials credentials, String repositoryName, HttpRequestRetryPolicy retryPolicy, Function<String, T> exceptionFactory, Logger interactionLogger) throws T {
        this(credentials.uri, credentials.username, credentials.password, repositoryName, retryPolicy, exceptionFactory, interactionLogger);
    }

    private <T extends Exception> AzureDevOpsGitClient(String url, String username, String password, String repositoryName, HttpRequestRetryPolicy retryPolicy, Function<String, T> exceptionFactory, Logger interactionLogger) throws T {
        Pair<String, String> projectAndRepo = GitRepositoryManagementConnectorDescriptorBase.splitRepositoryName(repositoryName, exceptionFactory);
        this.projectName = (String)projectAndRepo.getFirst();
        this.repositoryName = (String)projectAndRepo.getSecond();
        this.clientWithProjectInUrl = new TfsHttpConnection(StringUtils.ensureEndsWith((String)url, (String)"/") + this.projectName, username, password, retryPolicy, interactionLogger);
        this.clientWithoutProjectInUrl = new TfsHttpConnection(url, username, password, retryPolicy, interactionLogger);
        this.interactionLogger = interactionLogger;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public AzureDevOpsGitRepositoryDto getRepository(String repositoryName) throws ServiceCallException {
        return this.clientWithProjectInUrl.createAzureDevOpsGitRepositoryRestClient().getRepository(repositoryName);
    }

    public List<ISubscriptionRestClient.Subscription> getHookSubscriptions() throws ServiceCallException {
        return this.clientWithoutProjectInUrl.createSubscriptionRestClient().getSubscriptions().getValues();
    }

    public void createRepositoryWebHooks(String repositoryId, String projectId, String url, Set<String> events) throws ServiceCallException {
        ISubscriptionRestClient subscriptionRestClient = this.clientWithoutProjectInUrl.createSubscriptionRestClient();
        for (String event : events) {
            ISubscriptionRestClient.Subscription subscription = AzureDevOpsGitClient.createWebHookSubscription(repositoryId, projectId, url, event);
            MergeRequestUtils.performServiceCallWithLogging("create webhook", this.clientWithoutProjectInUrl.getServerAddress(), projectId, () -> subscriptionRestClient.createSubscription(subscription));
        }
    }

    public void replaceRepositoryWebHook(String subscriptionId, String repositoryId, String projectId, String url, String event) throws ServiceCallException {
        ISubscriptionRestClient subscriptionRestClient = this.clientWithoutProjectInUrl.createSubscriptionRestClient();
        ISubscriptionRestClient.Subscription subscription = AzureDevOpsGitClient.createWebHookSubscription(repositoryId, projectId, url, event);
        MergeRequestUtils.performServiceCallWithLogging("replace webhook", this.clientWithoutProjectInUrl.getServerAddress(), subscriptionId, () -> subscriptionRestClient.replaceSubscription(subscriptionId, subscription));
    }

    private static ISubscriptionRestClient.Subscription createWebHookSubscription(String repositoryId, String projectId, String url, String event) {
        return new ISubscriptionRestClient.Subscription("enabled", "tfs", event, "1.0-preview.1", "webHooks", "httpRequest", new ISubscriptionRestClient.PublisherInputs(repositoryId, projectId), new ISubscriptionRestClient.ConsumerInputs(url));
    }

    public List<AzureDevOpsGitPullRequestDto> getActivePullRequests() throws ServiceCallException {
        return this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequests(this.getRepositoryName()).getValues();
    }

    public AzureDevOpsGitPullRequestDto getPullRequest(long pullRequestId) throws ServiceCallException {
        return this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequest(this.repositoryName, pullRequestId);
    }

    public String getPullRequestUrl(long pullRequestId) {
        return this.clientWithProjectInUrl.getServerAddress() + "/_git/" + this.repositoryName + "/pullRequest/" + pullRequestId;
    }

    public List<String> getPullRequestFiles(String repositoryName, long pullRequestId) throws ServiceCallException {
        int pullRequestIterationsCount = this.getPulLRequestIterationsCount(pullRequestId);
        List<AzureDevOpsGitChangeEntryDto> changeEntries = this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequestIterationChanges(repositoryName, pullRequestId, pullRequestIterationsCount).getChangeEntries();
        return CollectionUtils.filterAndMap(changeEntries, changeEntry -> !"delete".equals(changeEntry.getChangeType()), changeEntry -> changeEntry.getChangeItem().getPath());
    }

    public void createPullRequestStatus(String repositoryName, int pullRequestId, AzureDevOpsGitPullRequestStatusDto pullRequestStatus) throws ServiceCallException {
        this.clientWithProjectInUrl.createPullRequestRestClient().createPullRequestStatus(repositoryName, pullRequestId, pullRequestStatus);
    }

    public void updatePullRequestDescription(String repositoryName, int pullRequestId, AzureDevOpsGitPullRequestDescriptionDto pullRequestDescription) throws ServiceCallException {
        MergeRequestUtils.performServiceCallWithLogging("update pull request description: " + pullRequestDescription.description, this.clientWithProjectInUrl.getServerAddress(), pullRequestId, () -> this.updatePullRequestWithEditableCheck(repositoryName, pullRequestId, pullRequestDescription));
    }

    private Optional<AzureDevOpsGitPullRequestDto> updatePullRequestWithEditableCheck(String repositoryName, int pullRequestId, AzureDevOpsGitPullRequestDescriptionDto pullRequestDescription) throws ServiceCallException {
        try {
            return Optional.ofNullable(this.clientWithProjectInUrl.createPullRequestRestClient().updatePullRequest(repositoryName, pullRequestId, pullRequestDescription));
        }
        catch (ServiceCallException e) {
            if (e.getResponseBody().contains("Microsoft.TeamFoundation.Git.Server.GitPullRequestNotEditableException")) {
                this.interactionLogger.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage("Did not update the description of pull request \"%s\" in repository \"%s\" because it's already closed and Azure DevOps prevents modifying closed pull requests.".formatted(pullRequestId, repositoryName), this.clientWithProjectInUrl.getServerAddress(), Integer.toString(pullRequestId)));
                return Optional.empty();
            }
            throw e;
        }
    }

    public List<AzureDevOpsGitPullRequestThreadDto> getTeamscaleThreads(String repositoryName, int pullRequestId) throws ServiceCallException {
        List<AzureDevOpsGitPullRequestThreadDto> threads = this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequestThreads(repositoryName, pullRequestId).getValues();
        return CollectionUtils.filter(threads, thread -> !thread.isDeleted() && thread.getThreadContext() != null && AzureDevOpsGitClient.containsTeamscaleComment(thread.getComments()));
    }

    public List<AzureDevOpsGitPullRequestThreadDto> getTeamscaleAggregatedTestGapThreads(String repositoryName, int pullRequestId) throws ServiceCallException {
        List<AzureDevOpsGitPullRequestThreadDto> threads = this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequestThreads(repositoryName, pullRequestId).getValues();
        return CollectionUtils.filter(threads, thread -> !thread.isDeleted() && thread.getThreadContext() == null && AzureDevOpsGitClient.containsListOfMarkdownTeamscaleTestGapComments(thread.getComments()));
    }

    private static boolean containsTeamscaleComment(List<AzureDevOpsGitThreadCommentDto> threadComments) {
        return CollectionUtils.anyMatch(threadComments, threadComment -> CcpCommentUtils.isTeamscaleFindingsComment(threadComment.getContent()) || CcpCommentUtils.isMarkdownTeamscaleTestGapComment(threadComment.getContent()));
    }

    private static boolean containsListOfMarkdownTeamscaleTestGapComments(List<AzureDevOpsGitThreadCommentDto> threadComments) {
        return CollectionUtils.anyMatch(threadComments, threadComment -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(threadComment.getContent()));
    }

    public void deletePullRequestComment(String repositoryName, int pullRequestId, int threadId, AzureDevOpsGitThreadCommentDto comment) throws ServiceCallException {
        MergeRequestUtils.performServiceCallWithLogging("delete pull request comment: " + comment.getContent(), this.clientWithProjectInUrl.getServerAddress(), comment.getId(), () -> this.clientWithProjectInUrl.createPullRequestRestClient().deletePullRequestComment(repositoryName, pullRequestId, threadId, comment.getId()));
    }

    public void createPullRequestThread(String repositoryName, int pullRequestId, AzureDevOpsGitPullRequestThreadDto thread) throws ServiceCallException {
        MergeRequestUtils.performServiceCallWithLogging("create pull request comment: " + thread.printThreadComments(), this.clientWithProjectInUrl.getServerAddress(), pullRequestId, () -> this.clientWithProjectInUrl.createPullRequestRestClient().createPullRequestThread(repositoryName, pullRequestId, thread));
    }

    public void updatePullRequestThreadStatus(String repositoryName, int pullRequestId, int threadId, String status) throws ServiceCallException {
        this.clientWithProjectInUrl.createPullRequestRestClient().updatePullRequestThread(repositoryName, pullRequestId, threadId, new AzureDevOpsGitPullRequestThreadDto(status));
    }

    public void addCommentToPullRequestThread(String repositoryName, int pullRequestId, int threadId, AzureDevOpsGitThreadCommentDto comment) throws ServiceCallException {
        this.clientWithProjectInUrl.createPullRequestRestClient().addPullRequestComment(repositoryName, pullRequestId, threadId, comment);
    }

    public void updateThreadComment(String repositoryName, int pullRequestId, int threadId, int commentId, String newContent) throws ServiceCallException {
        this.clientWithProjectInUrl.createPullRequestRestClient().updatePullRequestComment(repositoryName, pullRequestId, threadId, commentId, new AzureDevOpsGitThreadCommentDto(newContent));
    }

    public int getPulLRequestIterationsCount(long pullRequestId) throws ServiceCallException {
        return this.clientWithProjectInUrl.createPullRequestRestClient().getPullRequestIterations(this.repositoryName, pullRequestId).getCount();
    }
}

