/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.bitbucket.cloud.JWTAccessToken;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pagination.BitbucketCloudPaginatedPullRequest;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pagination.BitbucketCloudPaginatedPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pagination.BitbucketCloudPaginatedRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequest;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestCommit;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReport;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReportAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import java.util.List;
import okhttp3.MultipartBody;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Url;

public interface IBitbucketCloudApi
extends IRetrofitApi {
    public static final String API_URL = "2.0/";
    public static final String REPO_SLUG_PARAMETER_NAME = "reposlug";
    public static final String WORKSPACE_PARAMETER_NAME = "workspace";
    public static final String REPOSITORIES_IN_WORKSPACE_API_ENDPOINT = "2.0/repositories/{workspace}";
    public static final String REPOSITORY_API_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/";
    public static final String PULL_REQUESTS_API_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/pullrequests/";
    public static final String PULL_REQUEST_ID_PARAMETER_NAME = "pullRequestId";
    public static final String PULL_REQUEST_API_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/";
    public static final String WORKSPACE_API_ENDPOINT = "2.0/workspaces/{workspace}/";
    public static final String COMMIT_HASH_PARAMETER_NAME = "commitHash";
    public static final String COMMIT_API_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}";
    public static final String REPORT_ID_PARAMETER_NAME = "reportId";
    public static final String COMMENT_ID_PARAMETER_NAME = "commentId";
    public static final String REPORT_API_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/reports/{reportId}/";
    public static final String ACCESS_TOKEN_API_ENDPOINT = "site/oauth2/access_token/";
    public static final String PULL_REQUEST_COMMENTS_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/comments";
    public static final String PULL_REQUEST_COMMENT_ENDPOINT = "2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/comments/{commentId}";

    @GET(value="2.0/repositories/{workspace}/{reposlug}/")
    public BitbucketCloudRepository getInstallationRepository(@Path(value="workspace") String var1, @Path(value="reposlug") String var2) throws ServiceCallException;

    @GET(value="2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/")
    public BitbucketCloudPullRequest getPullRequest(@Path(value="workspace") String var1, @Path(value="reposlug") String var2, @Path(value="pullRequestId") long var3) throws ServiceCallException;

    @GET(value="2.0/workspaces/{workspace}/")
    public BitbucketCloudWorkspace getWorkspace(@Path(value="workspace") String var1) throws ServiceCallException;

    @GET(value="2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/?fields=hash")
    public BitbucketCloudPullRequestCommit getCommit(@Path(value="workspace") String var1, @Path(value="reposlug") String var2, @Path(value="commitHash") String var3) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @POST(value="2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/statuses/build")
    public Void postCommitStatus(@Body CommitStatus var1, @Path(value="workspace") String var2, @Path(value="reposlug") String var3, @Path(value="commitHash") String var4) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @POST(value="2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/reports/{reportId}/annotations")
    public Void postReportAnnotations(@Path(value="reportId") String var1, @Path(value="workspace") String var2, @Path(value="reposlug") String var3, @Path(value="commitHash") String var4, @Body List<BitbucketCloudCommitReportAnnotation> var5) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/reports/{reportId}/")
    public BitbucketCloudCommitReport postCommitReport(@Path(value="reportId") String var1, @Path(value="workspace") String var2, @Path(value="reposlug") String var3, @Path(value="commitHash") String var4, @Body BitbucketCloudCommitReport var5) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/")
    public BitbucketCloudPullRequest putUpdatePullRequest(@Path(value="workspace") String var1, @Path(value="reposlug") String var2, @Path(value="pullRequestId") long var3, @Body BitbucketCloudPullRequest var5) throws ServiceCallException;

    @DELETE(value="2.0/repositories/{workspace}/{reposlug}/commit/{commitHash}/reports/{reportId}/")
    public Void deleteReport(@Path(value="reportId") String var1, @Path(value="workspace") String var2, @Path(value="reposlug") String var3, @Path(value="commitHash") String var4) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @POST(value="2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/comments")
    public Void postPullRequestComment(@Path(value="workspace") String var1, @Path(value="reposlug") String var2, @Path(value="pullRequestId") long var3, @Body BitbucketCloudPullRequestComment var5) throws ServiceCallException;

    @DELETE(value="2.0/repositories/{workspace}/{reposlug}/pullrequests/{pullRequestId}/comments/{commentId}")
    public Void deletePullRequestComment(@Path(value="workspace") String var1, @Path(value="reposlug") String var2, @Path(value="pullRequestId") long var3, @Path(value="commentId") long var5) throws ServiceCallException;

    @GET
    public BitbucketCloudPaginatedPullRequest getPullRequestPaginationPage(@Url String var1) throws ServiceCallException;

    @GET
    public BitbucketCloudPaginatedRepository getRepositoryPaginationPage(@Url String var1) throws ServiceCallException;

    @GET
    public BitbucketCloudPaginatedPullRequestComment getPullRequestCommentPaginationPage(@Url String var1) throws ServiceCallException;

    @Multipart
    @POST(value="site/oauth2/access_token/")
    public JWTAccessToken getJwtAccessToken(@Part MultipartBody.Part var1) throws ServiceCallException;
}

