/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.ICrossRepositoryMergeRequestHandler;
import org.jspecify.annotations.NonNull;

public class BitbucketServerCrossRepositoryMergeRequestHandler
implements ICrossRepositoryMergeRequestHandler<BitbucketServerPullRequest> {
    @Override
    public CrossRepositoryMergeRequestSourceBranch getSourceBranch(@NonNull BitbucketServerPullRequest pullRequest) {
        return new CrossRepositoryMergeRequestSourceBranch(BitbucketServerCrossRepositoryMergeRequestHandler.getRemoteRef(pullRequest), pullRequest.id(), BitbucketServerCrossRepositoryMergeRequestHandler.getSourceIdentifier(pullRequest), BitbucketServerCrossRepositoryMergeRequestHandler.getRemoteSourceBranch(pullRequest));
    }

    private static String getRemoteRef(@NonNull BitbucketServerPullRequest pullRequest) {
        return "refs/pull-requests/" + pullRequest.id() + "/from";
    }

    private static String getSourceIdentifier(@NonNull BitbucketServerPullRequest pullRequest) {
        return pullRequest.sourceBranch().repository().getSlug();
    }

    private static String getRemoteSourceBranch(@NonNull BitbucketServerPullRequest pullRequest) {
        return pullRequest.sourceBranch().displayId();
    }

    @Override
    public boolean isCrossRepositoryMergeRequest(@NonNull BitbucketServerPullRequest pullRequest) {
        return !pullRequest.sourceBranch().repository().getProjectKey().equalsIgnoreCase(pullRequest.targetBranch().repository().getProjectKey()) || !pullRequest.sourceBranch().repository().getSlug().equalsIgnoreCase(pullRequest.targetBranch().repository().getSlug());
    }
}

