/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.replay;

import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.debug_dump.dump.RevCommitDump;
import com.teamscale.index.repository.git.debug_dump.replay.RepositoryMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.RepositoryException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class GitMainRepositoryMock
extends GitMainRepository {
    private List<Ref> branches;
    private Map<String, RevCommitDump> commitsByName;

    public GitMainRepositoryMock(GitRepositoryConnection connection) {
        super(connection);
    }

    public void setBranches(List<Ref> refs) {
        this.branches = refs;
    }

    @Override
    public List<Ref> getAllBranches(boolean filter) throws RepositoryException {
        if (filter) {
            return this.filterBranches(this.branches);
        }
        return new ArrayList<Ref>(this.branches);
    }

    @Override
    public Repository getRepository() {
        return new RepositoryMock();
    }

    @Override
    protected Long getNewestCommitTimestamp(Ref branchRef) {
        return this.commitsByName.get(branchRef.getObjectId().getName()).getTime();
    }

    @Override
    public boolean hasRemoteConfiguration() {
        return true;
    }

    public void setCommits(List<RevCommitDump> commits) {
        this.commitsByName = commits.stream().collect(Collectors.toMap(commit -> commit.name, Function.identity()));
    }
}

