/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.gitlab.data.GitLabBranch;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiscussion;
import com.teamscale.index.repository.git.gitlab.data.GitLabHook;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import com.teamscale.index.repository.git.gitlab.data.GitLabProjectUser;
import com.teamscale.index.repository.git.gitlab.data.GitLabUser;
import com.teamscale.index.repository.git.gitlab.data.GitLabVersion;
import com.teamscale.index.repository.git.gitlab.data.GitlabProjectLanguages;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGitLabApi
extends IRetrofitApi {
    public static final String REST_API_BASE_PATH = "api/v4/";
    public static final String PER_PAGE_PARAMETER_NAME = "per_page";
    public static final String REPO_PARAMETER_NAME = "repositoryName";
    public static final String USER_ID_PARAMETER_NAME = "userId";
    public static final String HOOK_ID_PARAMETER_NAME = "hookId";
    public static final String MERGE_REQUEST_ID_PARAMETER_NAME = "mergeRequestId";
    public static final String DISCUSSION_ID_PARAMETER_NAME = "discussionId";
    public static final String NOTE_ID_PARAMETER_NAME = "noteId";
    public static final String BODY_PARAMETER_NAME = "body";
    public static final String MIN_ACCESS_LEVEL_PARAMETER_NAME = "min_access_level";
    public static final String COMMIT_PARAMETER_NAME = "commit";
    public static final String VERSION_ENDPOINT = "api/v4/version";
    public static final String PROJECT_ENDPOINT = "api/v4/projects/{repositoryName}";
    public static final String PROJECT_USER_ENDPOINT = "api/v4/projects/{repositoryName}/members/all/{userId}";
    public static final String PROJECT_HOOKS_ENDPOINT = "api/v4/projects/{repositoryName}/hooks";
    public static final String PROJECT_SINGLE_HOOK_ENDPOINT = "api/v4/projects/{repositoryName}/hooks/{hookId}";
    public static final String MERGE_REQUESTS_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests";
    public static final String SINGLE_MERGE_REQUEST_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}";
    public static final String MERGE_REQUEST_DISCUSSIONS_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions";
    public static final String SINGLE_MERGE_REQUEST_WITH_CHANGES_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/changes";
    public static final String MERGE_REQUEST_SINGLE_DISCUSSION_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}";
    public static final String MERGE_REQUEST_DISCUSSION_NOTES_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}/notes";
    public static final String MERGE_REQUEST_DISCUSSION_SINGLE_NOTE_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}/notes/{noteId}";
    public static final String MERGE_REQUEST_SINGLE_NOTE_ENDPOINT = "api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/notes/{noteId}";
    public static final String PROJECTS_ENDPOINT = "api/v4/projects";
    public static final String PROJECT_LANGUAGES_ENDPOINT = "api/v4/projects/{repositoryName}/languages";
    public static final String BRANCHES_ENDPOINT = "api/v4/projects/{repositoryName}/repository/branches";
    public static final String COMMIT_STATUSES_ENDPOINT = "api/v4/projects/{repositoryName}/repository/commits/{commit}/statuses";

    @GET(value="api/v4/version")
    public GitLabVersion getVersion() throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}")
    public GitLabProject getProject(@Path(value="repositoryName") String var1) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/hooks")
    public GitLabHook[] getProjectHooks(@Path(value="repositoryName") String var1) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @POST(value="api/v4/projects/{repositoryName}/hooks")
    public Void postProjectHook(@Path(value="repositoryName") String var1, @Body GitLabHook var2) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="api/v4/projects/{repositoryName}/hooks/{hookId}")
    public Void updateProjectHook(@Path(value="repositoryName") String var1, @Path(value="hookId") int var2, @Body GitLabHook var3) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}")
    public GitLabMergeRequest getMergeRequest(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2) throws ServiceCallException;

    @FormUrlEncoded
    @PUT(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}")
    public Void updateMergeRequestDescription(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Field(value="description") String var4) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/merge_requests?state=opened&scope=all")
    public Call<GitLabMergeRequest[]> getOpenMergeRequests(@Path(value="repositoryName") String var1, @Query(value="per_page") int var2);

    @GET
    public Call<GitLabMergeRequest[]> getNextOpenMergeRequests(@Url String var1);

    @GET(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/changes")
    public GitLabMergeRequest getMergeRequestWithChanges(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions")
    public Call<GitLabDiscussion[]> getMergeRequestDiscussions(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Query(value="per_page") int var4);

    @GET
    public Call<GitLabDiscussion[]> getNextMergeRequestDiscussions(@Url String var1);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions")
    public GitLabDiscussion createMergeRequestDiscussion(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Body GitLabNote var4) throws ServiceCallException;

    @PUT(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}")
    public Void resolveMergeRequestDiscussion(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Path(value="discussionId") String var4, @Query(value="resolved") boolean var5) throws ServiceCallException;

    @FormUrlEncoded
    @PUT(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}/notes/{noteId}")
    public Void updateMergeRequestDiscussionNote(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Path(value="discussionId") String var4, @Path(value="noteId") long var5, @Field(value="body") String var7) throws ServiceCallException;

    @FormUrlEncoded
    @POST(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/discussions/{discussionId}/notes")
    public Void addNoteToDiscussion(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Path(value="discussionId") String var4, @Field(value="body") String var5) throws ServiceCallException;

    @DELETE(value="api/v4/projects/{repositoryName}/merge_requests/{mergeRequestId}/notes/{noteId}")
    public Void deleteMergeRequestNote(@Path(value="repositoryName") String var1, @Path(value="mergeRequestId") long var2, @Path(value="noteId") long var4) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/members/all/{userId}")
    public GitLabProjectUser getProjectUser(@Path(value="repositoryName") String var1, @Path(value="userId") int var2) throws ServiceCallException;

    @GET(value="api/v4/user")
    public GitLabUser getUser() throws ServiceCallException;

    @GET(value="api/v4/projects?order_by=last_activity_at")
    public List<GitLabProject> getProjectsWithAccessLevel(@Query(value="min_access_level") int var1) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/languages")
    public GitlabProjectLanguages getLanguagesForProject(@Path(value="repositoryName") String var1) throws ServiceCallException;

    @GET(value="api/v4/projects/{repositoryName}/repository/branches")
    public Call<GitLabBranch[]> getBranches(@Path(value="repositoryName") String var1, @Query(value="per_page") int var2);

    @GET
    public Call<GitLabBranch[]> getNextBranches(@Url String var1);

    @GET(value="api/v4/projects/{repositoryName}/repository/commits/{commit}/statuses")
    public Call<GitLabCommitStatus[]> getCommitStatuses(@Path(value="repositoryName") String var1, @Path(value="commit") String var2, @Query(value="per_page") int var3);

    @GET
    public Call<GitLabCommitStatus[]> getNextCommitStatuses(@Url String var1);
}

