/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public enum EAccessLevel {
    NO_ACCESS(0),
    MINIMAL_ACCESS(5),
    GUEST(10),
    REPORTER(20),
    DEVELOPER(30),
    MAINTAINER(40),
    OWNER(50),
    ADMIN(60);

    private static final UnmodifiableMap<Integer, EAccessLevel> LEVEL_LOOKUP;
    private final int level;

    private EAccessLevel(int level) {
        this.level = level;
    }

    @JsonValue
    public int getLevel() {
        return this.level;
    }

    @JsonCreator
    public static EAccessLevel fromLevel(int level) {
        EAccessLevel accessLevel = (EAccessLevel)((Object)LEVEL_LOOKUP.get((Object)level));
        if (accessLevel == null) {
            throw new IllegalArgumentException("Unknown access level: " + level);
        }
        return accessLevel;
    }

    static {
        LEVEL_LOOKUP = CollectionUtils.asUnmodifiable(Arrays.stream(EAccessLevel.values()).collect(Collectors.toMap(EAccessLevel::getLevel, Function.identity())));
    }
}

