/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.gitlab.data.GitLabPosition;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class GitLabNote {
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="body")
    private String body;
    private String username;
    @JsonProperty(value="position")
    private GitLabPosition position;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="resolved")
    private boolean resolved;
    @JsonProperty(value="system")
    private boolean system;

    public GitLabNote() {
    }

    public GitLabNote(String body) {
        this.body = body;
    }

    public GitLabNote(String body, GitLabPosition position) {
        this.body = body;
        this.position = position;
    }

    @JsonProperty(value="author")
    private void unpackNameFromNestedObject(Map<String, String> author) {
        this.username = author.get("username");
    }

    public long getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public String getUsername() {
        return this.username;
    }

    public GitLabPosition getPosition() {
        return this.position;
    }

    public LocalDateTime getUpdatedAt() {
        return LocalDateTime.parse(this.updatedAt, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public LocalDateTime getCreatedAt() {
        return LocalDateTime.parse(this.createdAt, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isSystemNote() {
        return this.system;
    }

    public String toString() {
        return "GitLabNote{id=" + this.id + ", body='" + this.body + "', position=" + String.valueOf(this.position) + "}";
    }
}

