/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.iec;

import com.teamscale.index.repository.ITokenElementInfoExtractor;
import com.teamscale.index.resource.element_details.IECLanguageDetail;
import com.teamscale.index.resource.element_details.STFileType;
import com.teamscale.index.resource.element_details.VariableDeclarationDetail;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.IShallowParser;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StructuredTextElementInfoExtractorBachmann
implements ITokenElementInfoExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, String> POU_TYPES = new HashMap<String, String>();
    private final IShallowParser parser;

    public StructuredTextElementInfoExtractorBachmann() {
        IShallowParser tmpParser = null;
        try {
            tmpParser = ShallowParserFactory.createParser((ELanguage)ELanguage.IEC61131);
        }
        catch (ShallowParserException e) {
            LOGGER.error("Could not create ST-Code parser for parsing variable declaration interface.");
        }
        this.parser = tmpParser;
    }

    @Override
    public BasicTokenElementInfo getElementInfo(ELanguage language, byte[] content, String uniformPath) {
        CCSMAssert.isTrue((boolean)this.canExtractFromSourceFile(language, content, uniformPath), (String)"Tried to extract embedded code with non-applicable extractor.");
        return this.createStructuredTextElement(uniformPath, content);
    }

    BasicTokenElementInfo createStructuredTextElement(String uniformPath, byte[] data) {
        Object structuredText = "";
        ArrayList deletions = new ArrayList();
        List<Object> details = new ArrayList<STFileType>();
        try {
            Document document = XMLUtils.parse((InputSource)new InputSource(new ByteArrayInputStream(data)));
            if (StructuredTextElementInfoExtractorBachmann.containsTypesTag(document)) {
                String typesSection = StructuredTextElementInfoExtractorBachmann.extractTypesSection(document);
                details = Collections.singletonList(STFileType.TYPES);
                return new BasicTokenElementInfo(uniformPath, ELanguage.IEC61131, false, typesSection, deletions, details);
            }
            structuredText = StructuredTextElementInfoExtractorBachmann.extractStructuredText(uniformPath, document);
            String rootEntityTypeAndName = StructuredTextElementInfoExtractorBachmann.getRootEntityTypeAndName(document);
            String pouType = POU_TYPES.get(StringUtils.getFirstPart((String)rootEntityTypeAndName, (char)' ').toLowerCase());
            details.add((Object)new IECLanguageDetail(new HashSet<String>(Collections.singleton("ST"))));
            if (!((String)structuredText).isEmpty() && pouType != null) {
                structuredText = (String)structuredText + "\nEND_" + pouType;
            }
            details.addAll(this.parseVariableDeclarations(document, uniformPath));
        }
        catch (IOException | SAXException e) {
            LOGGER.warn("Could not parse Structured Text from " + uniformPath, (Throwable)e);
        }
        details.add((Object)STFileType.CODE);
        return new BasicTokenElementInfo(uniformPath, ELanguage.IEC61131, false, (String)structuredText, deletions, details);
    }

    private static String getRootEntityTypeAndName(Document document) {
        Optional<Element> pouInterface = StructuredTextElementInfoExtractorBachmann.getInterfaceElementFromPouDocument(document);
        if (pouInterface.isEmpty()) {
            return "";
        }
        String text = pouInterface.get().getTextContent().trim();
        if (text.startsWith("PROGRAM ") || text.startsWith("FUNCTION_BLOCK ") || text.startsWith("FUNCTION ")) {
            return StringUtils.removeAll((String)StringUtils.getFirstPart((String)text, (char)'\n'), (String[])new String[]{"\r"});
        }
        LOGGER.warn("Could not determine root entity name/type");
        return "";
    }

    private static Optional<Element> getInterfaceElementFromPouDocument(Document document) {
        String rootNodeName = document.getDocumentElement().getNodeName();
        if ("pou".equals(rootNodeName) || "gvl".equals(rootNodeName)) {
            return Optional.ofNullable(XMLUtils.getNamedChild((Element)document.getDocumentElement(), (String)"interface"));
        }
        return Optional.empty();
    }

    private static String extractTypesSection(Document document) {
        Optional<Element> interfaceElement = StructuredTextElementInfoExtractorBachmann.getInterfaceElementFromPouDocument(document);
        if (interfaceElement.isEmpty()) {
            return "";
        }
        return interfaceElement.get().getTextContent();
    }

    private static String extractStructuredText(String uniformPath, Document document) {
        Object structuredText = "";
        NodeList stNodes = document.getElementsByTagName("st");
        NodeList interfaceNodes = document.getElementsByTagName("interface");
        if (interfaceNodes.getLength() >= 1) {
            Element interfaceNode;
            if (interfaceNodes.getLength() > 1) {
                LOGGER.warn("More than one <interface> node in " + uniformPath);
            }
            if ((interfaceNode = (Element)XMLUtils.elementNodes((NodeList)interfaceNodes).get(0)) != null) {
                structuredText = (String)structuredText + interfaceNode.getTextContent();
            }
        }
        if (stNodes.getLength() >= 1) {
            Element stNode;
            Element bodyNode;
            if (stNodes.getLength() > 1) {
                LOGGER.warn("More than one <ST> node in " + uniformPath);
            }
            if ((bodyNode = XMLUtils.getNamedChild((Element)(stNode = (Element)XMLUtils.elementNodes((NodeList)stNodes).get(0)), (String)"body")) != null) {
                structuredText = (String)structuredText + bodyNode.getTextContent();
            }
        }
        if (((String)structuredText).isEmpty()) {
            LOGGER.warn("No structured text found in " + uniformPath);
        }
        return structuredText;
    }

    private List<TokenElementDetailBase> parseVariableDeclarations(Document document, String uniformPath) {
        ArrayList<TokenElementDetailBase> details = new ArrayList<TokenElementDetailBase>();
        VariableDeclarationDetail detail = new VariableDeclarationDetail();
        details.add(detail);
        Optional<Element> pouInterface = StructuredTextElementInfoExtractorBachmann.getInterfaceElementFromPouDocument(document);
        if (pouInterface.isEmpty()) {
            return details;
        }
        List interfaceEntities = this.parser.parseTopLevel(ScannerUtils.getTokens((String)pouInterface.get().getTextContent(), (ELanguage)ELanguage.IEC61131, (String)uniformPath));
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)interfaceEntities, (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            switch (metaEntity.getSubtype()) {
                case "VAR": 
                case "VAR_ACCESS": 
                case "VAR_CONFIG": {
                    StructuredTextElementInfoExtractorBachmann.parseNodes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren(), detail::addLocalVariable);
                    break;
                }
                case "VAR_EXTERNAL": 
                case "VAR_GLOBAL": {
                    StructuredTextElementInfoExtractorBachmann.parseNodes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren(), detail::addExternalVariable);
                    break;
                }
                case "VAR_INPUT": 
                case "VAR_OUTPUT": {
                    StructuredTextElementInfoExtractorBachmann.parseNodes((UnmodifiableList<ShallowEntity>)metaEntity.getChildren(), detail::addInputOrOutputVariable);
                    break;
                }
            }
        }
        return details;
    }

    private static void parseNodes(UnmodifiableList<ShallowEntity> children, BiConsumer<String, String> add) {
        for (ShallowEntity child : children) {
            List variableNameTokens;
            if (child.getType() != EShallowEntityType.ATTRIBUTE || !child.getSubtype().equals("variable")) continue;
            List childTokens = TokenStreamUtils.removeAtEnd((List)child.ownStartTokens(), (ETokenType)ETokenType.SEMICOLON);
            int assignmentIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)childTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.ASSIGNMENT});
            int typeDeclarationIndex = assignmentIndex == -1 ? TokenStreamUtils.firstTokenMatching((List)childTokens, (ITokenMatcher)ETokenType.COLON) : TokenStreamUtils.firstTokenMatching((List)childTokens, (int)0, (int)assignmentIndex, (ITokenMatcher)ETokenType.COLON);
            List<Object> typeDeclarationTokens = Collections.emptyList();
            if (typeDeclarationIndex != -1 && assignmentIndex != -1) {
                typeDeclarationTokens = childTokens.subList(typeDeclarationIndex + 1, assignmentIndex);
                variableNameTokens = childTokens.subList(0, typeDeclarationIndex);
            } else if (typeDeclarationIndex != -1) {
                typeDeclarationTokens = childTokens.subList(typeDeclarationIndex + 1, childTokens.size());
                variableNameTokens = childTokens.subList(0, typeDeclarationIndex);
            } else {
                variableNameTokens = childTokens;
            }
            String variableName = TokenStreamTextUtils.concatTokenTexts((List)variableNameTokens, (String)" ");
            String typeName = TokenStreamTextUtils.concatTokenTexts(typeDeclarationTokens, (String)" ");
            add.accept(variableName, typeName);
        }
    }

    private static boolean isStructuredTextCodeEmbeddedInXML(byte[] content, String uniformPath) {
        String extension = FileSystemUtils.getFileExtension((String)uniformPath);
        if ("xml".equalsIgnoreCase(extension)) {
            extension = FileSystemUtils.getFileExtension((String)uniformPath.substring(0, uniformPath.length() - 4));
        }
        return StructuredTextElementInfoExtractorBachmann.isStructuredTextCodeInXmlWithExtension(content, extension, "pou", "<pou>") || StructuredTextElementInfoExtractorBachmann.isStructuredTextCodeInXmlWithExtension(content, extension, "gvl", "<gvl>") || StructuredTextElementInfoExtractorBachmann.isStructuredTextCodeInXmlWithExtension(content, extension, "dut", "<dut>");
    }

    private static boolean isStructuredTextCodeInXmlWithExtension(byte[] content, String actualExtension, String expectedExtension, String expectedTag) {
        return expectedExtension.equalsIgnoreCase(actualExtension) && ByteArrayUtils.indexOf((byte[])StringUtils.stringToBytes((String)expectedTag), (byte[])content, (int)0, (int)100) != -1;
    }

    private static boolean containsTypesTag(Document document) {
        String nodeName = document.getDocumentElement().getNodeName();
        return "gvl".equals(nodeName) || "dut".equals(nodeName);
    }

    @Override
    public boolean canExtractFromSourceFile(ELanguage language, byte[] content, String uniformPath) {
        return StructuredTextElementInfoExtractorBachmann.isStructuredTextCodeEmbeddedInXML(content, uniformPath);
    }

    static {
        POU_TYPES.put("function", "FUNCTION");
        POU_TYPES.put("function_block", "FUNCTION_BLOCK");
        POU_TYPES.put("program", "PROGRAM");
    }
}

