/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import java.util.ArrayList;
import java.util.HashSet;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AbapConnectorHealthStatusPersister {
    public static void setConnectionStatus(IndexLayer indexLayer, String sapSystemNameFromAbapTrigger, ProjectConnectorStatus.EConnectorStatus eStatus, String message) throws StorageException {
        Multimap<PublicProjectId, String> projectConnectorIds = AbapConnectorHealthStatusPersister.getProjectConnectorsUsingSapSystem(indexLayer, sapSystemNameFromAbapTrigger);
        if (projectConnectorIds.isEmpty()) {
            return;
        }
        for (PublicProjectId publicProjectId : projectConnectorIds.keySet()) {
            ProjectConnectorStatusIndex projectConnectorStatusIndex = (ProjectConnectorStatusIndex)indexLayer.openProjectIndex((IProjectId)publicProjectId, ProjectConnectorStatusIndex.class, null);
            ArrayList repositoryConnectorIds = new ArrayList(projectConnectorIds.get((Object)publicProjectId));
            for (String repositoryConnectorId : repositoryConnectorIds) {
                ProjectConnectorStatus currentConnectorStatus = AbapConnectorHealthStatusPersister.prepareCurrentConnectorStatus(eStatus, message, projectConnectorStatusIndex, repositoryConnectorId);
                projectConnectorStatusIndex.setStatus(currentConnectorStatus);
            }
        }
    }

    private static ProjectConnectorStatus prepareCurrentConnectorStatus(ProjectConnectorStatus.EConnectorStatus eStatus, String message, ProjectConnectorStatusIndex projectConnectorStatusIndex, String repositoryConnectorId) throws StorageException {
        Long lastSuccess = 0L;
        Long lastAttempt = System.currentTimeMillis();
        if (eStatus == ProjectConnectorStatus.EConnectorStatus.HEALTHY) {
            lastSuccess = lastAttempt;
        } else {
            ProjectConnectorStatus previousConnectorStatus = projectConnectorStatusIndex.getStatus(repositoryConnectorId);
            if (previousConnectorStatus != null) {
                lastSuccess = previousConnectorStatus.getLastSuccess();
            }
        }
        return new ProjectConnectorStatus(repositoryConnectorId, eStatus, lastSuccess, lastAttempt, message);
    }

    private static Multimap<PublicProjectId, String> getProjectConnectorsUsingSapSystem(IndexLayer indexLayer, String sapSystemNameFromAbapTrigger) throws StorageException {
        ArrayListMultimap connectorIds = ArrayListMultimap.create();
        ProjectIndex projectIndex = (ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class);
        HashSet abapConnectorTypes = CollectionUtils.asHashSet((Object[])new String[]{ERepositoryConnector.ABAP_GIT.getReadableName(), ERepositoryConnector.GIT.getReadableName()});
        for (PublicProjectId publicProjectId : projectIndex.getAllPrimaryPublicProjectIds()) {
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)publicProjectId, (IndexLayer)indexLayer);
            for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
                if (!abapConnectorTypes.contains(connectorConfiguration.getType())) continue;
                String gitConnectorPathSuffix = sapSystemNameFromAbapTrigger + "/git";
                if (!sapSystemNameFromAbapTrigger.equals(connectorConfiguration.getOptionValue("SAP connection")) && !gitConnectorPathSuffix.equals(connectorConfiguration.getOptionValue("Path suffix"))) continue;
                connectorIds.put((Object)publicProjectId, (Object)connectorConfiguration.getIdentifier());
            }
        }
        return connectorIds;
    }
}

