/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnExternalsRetriever;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import com.teamscale.index.repository.svn.SvnRepositoryExecutor;
import com.teamscale.index.repository.svn.SvnRepositoryViewBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.StringLengthComparator;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnLogQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int LOG_QUERY_SIZE = 200;
    private static final Pattern FILE_NOT_FOUND_PATH_PATTERN = Pattern.compile("path '([^']*)'");
    private final String repositoryRoot;
    private final SVNRepository rootRepository;
    private final String pathCutOffPrefix;
    private final List<SvnExternalTarget> externalTargets;
    private final List<String> allExternalWcPaths;
    private final SvnLogCacheIndex logCacheIndex;
    private final PredicateWithException<String, RepositoryException> isPathIncluded;
    private final Function<String, Optional<String>> branchNameExtractor;
    private final Predicate<String> canSubPathsBeIncluded;
    private final String branchesDirectory;
    private boolean logExhausted = false;
    private long lastRevision;
    private final Deque<SvnChangeEntry> entries = new LinkedList<SvnChangeEntry>();
    private final Deque<SVNLogEntry> unprocessedEntries = new LinkedList<SVNLogEntry>();
    private final IncludeExcludeAntPatternSupport externalsPatternSupport;
    private final SvnRepositoryExecutor repositoryExecutor;

    public SvnLogQueue(String repositoryRoot, SVNRepository rootRepository, List<SvnExternalTarget> externalTargets, List<String> allExternalWcPaths, SvnLogCacheIndex logCacheIndex, long timestamp, IncludeExcludeAntPatternSupport externalsPatternSupport, SvnRepositoryExecutor repositoryExecutor, PredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded, Function<String, Optional<String>> branchNameExtractor, String branchesDirectory) throws RepositoryException {
        this.repositoryRoot = repositoryRoot;
        this.rootRepository = rootRepository;
        this.pathCutOffPrefix = this.determinePathCutOffPrefix();
        this.externalTargets = externalTargets;
        this.allExternalWcPaths = allExternalWcPaths;
        this.logCacheIndex = logCacheIndex;
        this.lastRevision = this.loadCachedEntriesAndGetLastRevision(repositoryRoot, rootRepository, logCacheIndex, timestamp);
        this.externalsPatternSupport = externalsPatternSupport;
        this.repositoryExecutor = repositoryExecutor;
        this.isPathIncluded = isPathIncluded;
        this.canSubPathsBeIncluded = canSubPathsBeIncluded;
        this.branchNameExtractor = branchNameExtractor;
        this.branchesDirectory = branchesDirectory;
    }

    private String determinePathCutOffPrefix() throws RepositoryException {
        try {
            SVNURL realRepositoryRoot = this.rootRepository.getRepositoryRoot(false);
            if (realRepositoryRoot == null) {
                realRepositoryRoot = this.rootRepository.getRepositoryRoot(true);
            }
            String rootRepositoryLocation = this.rootRepository.getLocation().toDecodedString();
            String realRepositoryRootLocation = realRepositoryRoot.toDecodedString();
            if (realRepositoryRootLocation.equals(rootRepositoryLocation)) {
                return null;
            }
            return StringUtils.stripPrefix((String)rootRepositoryLocation, (String)realRepositoryRootLocation);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private long loadCachedEntriesAndGetLastRevision(String repositoryRoot, SVNRepository rootRepository, SvnLogCacheIndex logCacheIndex, long timestamp) throws RepositoryException {
        try {
            long lastKnownRevision = Math.max(0L, logCacheIndex.getOriginRevisionForTimestamp(repositoryRoot, timestamp));
            this.entries.addAll(CollectionUtils.filter(logCacheIndex.getLogEntriesAfter(repositoryRoot, lastKnownRevision), entry -> entry.getTimestamp() > timestamp));
            if (!this.entries.isEmpty()) {
                return this.entries.getLast().getRevision();
            }
            long lastRevision = SVNUtils.getRevisionForTimestamp(rootRepository, timestamp);
            if (lastKnownRevision == 0L) {
                logCacheIndex.insertTimestampToRevisionMapping(timestamp, lastRevision, repositoryRoot);
            }
            return lastRevision;
        }
        catch (StorageException | SVNException e) {
            throw new RepositoryException(e);
        }
    }

    public boolean isEmpty() throws RepositoryException {
        this.ensureEntries();
        return this.entries.isEmpty();
    }

    public SvnChangeEntry peekEntry() throws RepositoryException {
        this.ensureEntries();
        return this.entries.peek();
    }

    public SvnChangeEntry pollEntry() throws RepositoryException {
        this.ensureEntries();
        return this.entries.poll();
    }

    private void ensureEntries() throws RepositoryException {
        if (!this.entries.isEmpty() || this.logExhausted) {
            return;
        }
        this.ensureUnprocessedEntries();
        if (!this.unprocessedEntries.isEmpty()) {
            SvnChangeEntry newEntry = this.convertLogEntryToChangeEntry(this.unprocessedEntries.poll());
            this.entries.add(newEntry);
            try {
                this.logCacheIndex.insertLogEntries(Collections.singletonList(newEntry));
            }
            catch (StorageException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void ensureUnprocessedEntries() throws RepositoryException {
        if (!this.unprocessedEntries.isEmpty()) {
            return;
        }
        long startRevision = this.lastRevision + 1L;
        try {
            long latestRevision = this.rootRepository.getLatestRevision();
            while (startRevision <= latestRevision) {
                long endRevision = Math.min(startRevision + 200L, latestRevision);
                String[] allSubPaths = (String[])CollectionUtils.toArray((Collection)CollectionUtils.map(this.externalTargets, SvnExternalTarget::getRepositorySuffix), String.class);
                ArrayList<SVNLogEntry> svnEntries = new ArrayList<SVNLogEntry>();
                endRevision = this.collectLogEntries(startRevision, endRevision, allSubPaths, svnEntries);
                if (!svnEntries.isEmpty()) {
                    this.unprocessedEntries.addAll(svnEntries);
                    this.lastRevision = this.unprocessedEntries.getLast().getRevision();
                    return;
                }
                startRevision = endRevision + 1L;
            }
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.logExhausted = true;
    }

    private long collectLogEntries(long startRevision, long endRevision, String[] allSubPaths, List<SVNLogEntry> svnEntries) throws SVNException {
        try {
            svnEntries.addAll(CollectionUtils.filter((Collection)this.rootRepository.log(allSubPaths, null, startRevision, endRevision, true, false), SvnLogQueue::isCompleteEntry));
            return endRevision;
        }
        catch (SVNException e) {
            return this.collectLogEntriesWithTimestampAdjustment(startRevision, endRevision, allSubPaths, svnEntries);
        }
    }

    private static boolean isCompleteEntry(SVNLogEntry entry) {
        return entry != null && entry.getAuthor() != null && entry.getDate() != null;
    }

    private long collectLogEntriesWithTimestampAdjustment(long startRevision, long endRevision, String[] allSubPaths, List<SVNLogEntry> svnEntries) throws AssertionError, SVNException {
        ArrayList<String> subPaths = new ArrayList<String>();
        ArrayList headRevisionFutures = new ArrayList();
        long queryEndRevision = endRevision;
        for (String subPath : allSubPaths) {
            headRevisionFutures.add(this.repositoryExecutor.submit(repo -> SvnLogQueue.determineHeadRevision(subPath, startRevision, queryEndRevision, repo), this.rootRepository));
        }
        for (int i = 0; i < allSubPaths.length; ++i) {
            Pair headRevisionAndException;
            try {
                headRevisionAndException = (Pair)((Future)headRevisionFutures.get(i)).get();
            }
            catch (InterruptedException | ExecutionException e1) {
                throw new AssertionError("Unexpected interruption: " + e1.getMessage(), e1);
            }
            if (headRevisionAndException.getSecond() != null) {
                throw (SVNException)((Object)headRevisionAndException.getSecond());
            }
            long headRevision = (Long)headRevisionAndException.getFirst();
            if (headRevision < startRevision) continue;
            endRevision = Math.min(endRevision, headRevision);
            subPaths.add(allSubPaths[i]);
        }
        this.retrieveAndFillSVNLogEntriesForSubPaths(startRevision, endRevision, svnEntries, subPaths);
        return endRevision;
    }

    private void retrieveAndFillSVNLogEntriesForSubPaths(long startRevision, long endRevision, List<SVNLogEntry> svnEntries, List<String> subPaths) throws SVNException {
        boolean wasExecutedWithEmptyPaths = false;
        while (!wasExecutedWithEmptyPaths) {
            try {
                if (subPaths.isEmpty()) {
                    wasExecutedWithEmptyPaths = true;
                }
                List result = CollectionUtils.filter((Collection)this.rootRepository.log((String[])CollectionUtils.toArray(subPaths, String.class), null, startRevision, endRevision, true, false), SvnLogQueue::isCompleteEntry);
                svnEntries.addAll(result);
                break;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    SvnLogQueue.removeUnknownSubPathIfPossible(subPaths, e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static void removeUnknownSubPathIfPossible(List<String> subPaths, SVNException e) throws SVNException {
        Matcher matcher = FILE_NOT_FOUND_PATH_PATTERN.matcher(e.getErrorMessage().getFullMessage());
        if (!matcher.find()) {
            LOGGER.error("File not found at revision, but could not match the path in the error description. Bailing out!", (Throwable)e);
            throw e;
        }
        String path = matcher.group(1);
        String trimmedPath = SvnExternalTarget.trimSlashes(path);
        if (!subPaths.remove(trimmedPath)) {
            LOGGER.error("Could not find " + trimmedPath + " in subpaths: " + String.valueOf(subPaths), (Throwable)e);
            throw e;
        }
        LOGGER.warn("File not found at revision, skipping!", (Throwable)e);
    }

    private static long determineHeadRevision(String path, long startRevision, long endRevision, SVNRepository repository) throws SVNException {
        if (repository.info(path, startRevision) == null) {
            return -1L;
        }
        for (long result = endRevision; result > startRevision; result -= Math.max(1L, (result - startRevision) / 2L)) {
            if (repository.info(path, result) == null) continue;
            return result;
        }
        return startRevision;
    }

    private SvnChangeEntry convertLogEntryToChangeEntry(SVNLogEntry logEntry) throws RepositoryException {
        SvnChangeEntry changeEntry = new SvnChangeEntry(logEntry.getRevision(), this.repositoryRoot, logEntry.getDate().getTime(), logEntry.getAuthor(), StringUtils.emptyIfNull((String)logEntry.getMessage()));
        Map changedPaths = logEntry.getChangedPaths();
        try {
            for (String changedPath : SvnLogQueue.getSortedChangedPaths(changedPaths)) {
                this.attachPathToChangeSet(changeEntry, logEntry, this.adjustLogEntryPath((SVNLogEntryPath)changedPaths.get(changedPath)));
            }
        }
        catch (StorageException | SVNException e) {
            throw new RepositoryException(e);
        }
        return changeEntry;
    }

    private SVNLogEntryPath adjustLogEntryPath(SVNLogEntryPath logEntryPath) {
        if (this.pathCutOffPrefix == null) {
            return logEntryPath;
        }
        String copyPath = null;
        if (logEntryPath.getCopyPath() != null) {
            copyPath = StringUtils.stripPrefix((String)logEntryPath.getCopyPath(), (String)this.pathCutOffPrefix);
        }
        return new SVNLogEntryPath(StringUtils.stripPrefix((String)logEntryPath.getPath(), (String)this.pathCutOffPrefix), logEntryPath.getType(), copyPath, logEntryPath.getCopyRevision(), logEntryPath.getKind());
    }

    private static List<String> getSortedChangedPaths(Map<?, ?> changedPaths) {
        List stringPaths = CollectionUtils.map(changedPaths.keySet(), String::valueOf);
        return CollectionUtils.sort((Collection)stringPaths, (Comparator)new StringLengthComparator().reversed());
    }

    private void attachPathToChangeSet(SvnChangeEntry changeEntry, SVNLogEntry logEntry, SVNLogEntryPath logEntryPath) throws SVNException, StorageException, RepositoryException {
        long revision = logEntry.getRevision();
        char change = logEntryPath.getType();
        String serverPath = logEntryPath.getPath();
        if (change == 'D' && this.isDirectory(logEntryPath, revision - 1L)) {
            if (!this.isServerSubPathIncluded(serverPath)) {
                return;
            }
            this.attachPathsFromDirectoryDelete(serverPath, logEntry, changeEntry);
            this.updateExternalsForDeletedDirectory(changeEntry, serverPath);
        } else if (change == 'A' && this.isDirectory(logEntryPath, revision)) {
            if (!this.isServerSubPathIncluded(serverPath)) {
                return;
            }
            if (logEntryPath.getCopyPath() != null) {
                this.attachPathsFromDirectoryAdd(logEntry, logEntryPath, changeEntry);
                this.updateExternalsForAddedDirectory(changeEntry, serverPath, revision);
            } else {
                this.handleModifiedDirectory(changeEntry, serverPath, revision, true);
            }
        } else if (change == 'M' && this.isDirectory(logEntryPath, revision)) {
            if (!this.isServerSubPathIncluded(serverPath)) {
                return;
            }
            this.handleModifiedDirectory(changeEntry, serverPath, revision, false);
        } else if (change == 'R' && this.isDirectory(logEntryPath, revision)) {
            if (!this.isServerSubPathIncluded(serverPath)) {
                return;
            }
            this.handleReplacedDirectory(changeEntry, serverPath, revision, logEntry, logEntryPath);
        } else {
            this.handleFile(changeEntry, revision, logEntryPath, this.rootRepository);
        }
    }

    private boolean isDirectory(SVNLogEntryPath logEntryPath, long revision) {
        return SVNUtils.isDirectory(logEntryPath, revision, this.rootRepository);
    }

    private void handleReplacedDirectory(SvnChangeEntry changeEntry, String serverPath, long revision, SVNLogEntry logEntry, SVNLogEntryPath logEntryPath) throws SVNException, StorageException, RepositoryException {
        Set<String> serverPaths = this.crawl(serverPath, revision - 1L);
        this.addAllPaths(changeEntry, serverPaths, null, null, ERepositoryChangeType.DELETE, -1L);
        this.updateExternalsForDeletedDirectory(changeEntry, serverPath);
        if (logEntryPath.getCopyPath() != null) {
            this.attachPathsFromDirectoryAdd(logEntry, logEntryPath, changeEntry);
            this.updateExternalsForAddedDirectory(changeEntry, serverPath, revision);
        }
    }

    private void updateExternalsForDeletedDirectory(SvnChangeEntry changeEntry, String serverPath) {
        if (!this.handleExternals()) {
            return;
        }
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(serverPath)) continue;
            String wcPath = target.resolveServerToWcPath(serverPath);
            for (String externalWcPath : this.allExternalWcPaths) {
                if (!externalWcPath.startsWith(wcPath)) continue;
                changeEntry.addClearedExternalPath(externalWcPath);
            }
        }
    }

    private void updateExternalsForAddedDirectory(SvnChangeEntry changeEntry, String serverPath, long revision) throws SVNException {
        if (!this.handleExternals()) {
            return;
        }
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(serverPath)) continue;
            String wcPath = target.resolveServerToWcPath(serverPath);
            List<SvnExternalTarget> externals = SvnExternalsRetriever.getExternalsRemote(wcPath, this.rootRepository, serverPath, revision, true, this.repositoryExecutor, this.externalsPatternSupport, this.canSubPathsBeIncluded);
            for (SvnExternalTarget external : externals) {
                changeEntry.addAddedExternalTarget(external.copyWithPrefixedLocalPath(wcPath));
            }
        }
    }

    private void handleModifiedDirectory(SvnChangeEntry changeEntry, String serverPath, long revision, boolean isAdd) throws SVNException {
        String trimmedServerPath = SvnExternalTarget.trimSlashes(serverPath);
        Optional<SvnExternalTarget> rootTarget = this.externalTargets.stream().filter(target -> target.getLocalPath().isEmpty() && target.containsServerPath(trimmedServerPath)).findFirst();
        rootTarget.ifPresent(target -> changeEntry.addRootRepoModifiedDirectory(target.resolveServerToWcPath(trimmedServerPath)));
        if (this.handleExternals()) {
            this.handleExternalsForModifiedDirectory(changeEntry, trimmedServerPath, revision, isAdd);
        }
    }

    private void handleExternalsForModifiedDirectory(SvnChangeEntry changeEntry, String serverPath, long revision, boolean isAdd) throws SVNException {
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(serverPath)) continue;
            String modifiedWcPath = target.resolveServerToWcPath(serverPath);
            Map<String, SvnExternalTarget> newExternals = this.getExternals(modifiedWcPath, serverPath, revision);
            Map<Object, Object> oldExternals = new HashMap();
            if (!isAdd) {
                oldExternals = this.getExternals(modifiedWcPath, serverPath, revision - 1L);
            }
            HashSet deletedKeys = CollectionUtils.differenceSet(oldExternals.keySet(), (Collection[])new Collection[]{newExternals.keySet()});
            HashSet addedOrChangedKeys = CollectionUtils.differenceSet(newExternals.keySet(), (Collection[])new Collection[]{deletedKeys});
            for (String addedOrChanged : addedOrChangedKeys) {
                changeEntry.addAddedExternalTarget(newExternals.get(addedOrChanged).copyWithPrefixedLocalPath(modifiedWcPath));
            }
            this.updateClearedExternalPaths(changeEntry, modifiedWcPath, deletedKeys);
        }
    }

    private void updateClearedExternalPaths(SvnChangeEntry changeEntry, String modifiedWorkingCopyPath, Set<String> deletedKeys) {
        for (String deleted : deletedKeys) {
            String workingCopyPath = UniformPathUtils.concatenate((String[])new String[]{modifiedWorkingCopyPath, deleted});
            for (String externalWorkingCopyPath : this.allExternalWcPaths) {
                if (!externalWorkingCopyPath.startsWith(workingCopyPath)) continue;
                changeEntry.addClearedExternalPath(externalWorkingCopyPath);
            }
        }
    }

    private Map<String, SvnExternalTarget> getExternals(String wcPath, String serverPath, long revision) throws SVNException {
        HashSet seenLocalPaths = new HashSet();
        return SvnExternalsRetriever.getExternalsRemote(wcPath, this.rootRepository, serverPath, revision, false, this.repositoryExecutor, this.externalsPatternSupport, this.canSubPathsBeIncluded).stream().filter(target -> {
            boolean result = seenLocalPaths.add(target.getLocalPath());
            if (!result) {
                LOGGER.warn("Had duplicate externals " + target.getLocalPath() + " for " + wcPath + "@" + revision + ". Ignoring second one!");
            }
            return result;
        }).collect(Collectors.toMap(SvnExternalTarget::getLocalPath, Function.identity()));
    }

    private boolean handleExternals() {
        return this.externalsPatternSupport != null;
    }

    private void addAllPaths(SvnChangeEntry changeEntry, Set<String> serverPaths, String newPrefix, String originPrefix, ERepositoryChangeType changeType, long originRevision) throws StorageException, RepositoryException, SVNException {
        newPrefix = SvnExternalTarget.trimSlashes(newPrefix);
        originPrefix = SvnExternalTarget.trimSlashes(originPrefix);
        for (String serverPath : serverPaths) {
            String serverOrigin = null;
            if (newPrefix != null && originPrefix != null && serverPath.startsWith(newPrefix)) {
                serverOrigin = UniformPathUtils.concatenate((String[])new String[]{originPrefix, SvnExternalTarget.trimSlashes(StringUtils.stripPrefix((String)serverPath, (String)newPrefix))});
            }
            this.addEntry(changeEntry, changeType, serverPath, serverOrigin, originRevision);
        }
    }

    private void handleFile(SvnChangeEntry changeEntry, long revision, SVNLogEntryPath logEntryPath, SVNRepository repository) throws StorageException, RepositoryException, SVNException {
        String serverPath = logEntryPath.getPath();
        char change = logEntryPath.getType();
        if (change == 'D' && SVNUtils.isFile(logEntryPath, revision - 1L, repository)) {
            this.addEntry(changeEntry, ERepositoryChangeType.DELETE, serverPath, null, -1L);
        } else if (SVNUtils.isFile(logEntryPath, revision, repository)) {
            ERepositoryChangeType changeType = ERepositoryChangeType.EDIT;
            if (change == 'A' || change == 'R' && !SVNUtils.fileExists(logEntryPath.getPath(), revision - 1L, this.rootRepository)) {
                changeType = ERepositoryChangeType.ADD;
            }
            String serverOrigin = logEntryPath.getCopyPath();
            long originRevision = -1L;
            if (serverOrigin != null) {
                originRevision = logEntryPath.getCopyRevision();
            }
            this.addEntry(changeEntry, changeType, serverPath, serverOrigin, originRevision);
        }
    }

    private void addEntry(SvnChangeEntry changeEntry, ERepositoryChangeType changeType, String serverPath, String serverOrigin, long originRevision) throws StorageException, RepositoryException, SVNException {
        serverPath = SvnExternalTarget.trimSlashes(serverPath);
        serverOrigin = SvnExternalTarget.trimSlashes(serverOrigin);
        boolean originLogMissing = false;
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(serverPath)) continue;
            String localPath = target.resolveServerToWcPath(serverPath);
            this.branchNameExtractor.apply(localPath).ifPresent(changeEntry::addBranchName);
            if (!this.isPathIncluded.test((Object)localPath)) continue;
            String localOrigin = null;
            CommitDescriptor originCommit = null;
            if (serverOrigin != null && serverOrigin.startsWith(target.getRepositorySuffix()) && !originLogMissing) {
                SvnChangeEntry originLog = this.ensureLogInCacheIndex(this.repositoryRoot, originRevision);
                if (originLog != null && this.isPathIncluded.test((Object)target.resolveServerToWcPath(serverOrigin))) {
                    localOrigin = target.resolveServerToWcPath(serverOrigin);
                    originCommit = CommitDescriptor.createUnbranchedDescriptor((long)originLog.getTimestamp());
                } else if (originLog == null) {
                    originLogMissing = true;
                }
            }
            changeEntry.addChange(localPath, changeType, localOrigin, originCommit);
        }
    }

    private SvnChangeEntry ensureLogInCacheIndex(String repositoryRoot, long originRevision) throws StorageException, SVNException, RepositoryException {
        SvnChangeEntry originLog = this.logCacheIndex.getRepositoryLog(repositoryRoot, originRevision);
        if (originLog != null) {
            return originLog;
        }
        ArrayList<SVNLogEntry> logEntries = new ArrayList<SVNLogEntry>();
        this.collectLogEntries(originRevision, originRevision, new String[0], logEntries);
        if (logEntries.isEmpty()) {
            LOGGER.warn("Could not find SVNLogEntry for revision {}", (Object)originRevision);
            return null;
        }
        originLog = this.convertLogEntryToChangeEntry((SVNLogEntry)logEntries.get(0));
        this.logCacheIndex.insertLogEntries(Collections.singletonList(originLog));
        return originLog;
    }

    private void attachPathsFromDirectoryDelete(String deletedServerPath, SVNLogEntry logEntry, SvnChangeEntry changeEntry) throws SVNException, StorageException, RepositoryException {
        if (this.isBranchDeletion(deletedServerPath)) {
            return;
        }
        Set<String> serverPaths = this.crawl(deletedServerPath, logEntry.getRevision() - 1L);
        this.addAllPaths(changeEntry, serverPaths, null, null, ERepositoryChangeType.DELETE, -1L);
    }

    private boolean isBranchDeletion(String deletedServerPath) {
        Optional<String> branchName = this.branchNameExtractor.apply(deletedServerPath = StringUtils.stripPrefix((String)deletedServerPath, (String)"/"));
        if (branchName.isEmpty()) {
            return false;
        }
        String branchDirectory = StringUtils.ensureEndsWith((String)this.branchesDirectory, (String)"/") + branchName.get();
        return deletedServerPath.equals(branchDirectory);
    }

    private void attachPathsFromDirectoryAdd(SVNLogEntry logEntry, SVNLogEntryPath logEntryPath, SvnChangeEntry changeEntry) throws SVNException, StorageException, RepositoryException {
        Set<String> serverPaths = this.crawl(logEntryPath.getPath(), logEntry.getRevision());
        this.addAllPaths(changeEntry, serverPaths, logEntryPath.getPath(), logEntryPath.getCopyPath(), ERepositoryChangeType.ADD, logEntryPath.getCopyRevision());
    }

    private Set<String> crawl(String serverPath, long revision) throws SVNException {
        Predicate<String> canSubPathsBeIncluded = x -> true;
        return SvnRepositoryViewBase.crawl(this.rootRepository, serverPath, revision, this.repositoryExecutor, (PredicateWithException<String, RepositoryException>)((PredicateWithException)this::isServerPathIncluded), canSubPathsBeIncluded);
    }

    private boolean isServerPathIncluded(String serverPath) throws RepositoryException {
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(serverPath) || !this.isPathIncluded.test((Object)target.resolveServerToWcPath(serverPath))) continue;
            return true;
        }
        return false;
    }

    private boolean isServerSubPathIncluded(String serverDirectoryPath) {
        String trimmedServerPath = SvnExternalTarget.trimSlashes(serverDirectoryPath);
        for (SvnExternalTarget target : this.externalTargets) {
            if (!target.containsServerPath(trimmedServerPath) || !this.canSubPathsBeIncluded.test(target.resolveServerToWcPath(serverDirectoryPath))) continue;
            return true;
        }
        return false;
    }
}

