/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SvnRepositoryExecutor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.conqat.lib.commons.collections.Pair;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

abstract class SvnQueryTaskBase {
    protected final SVNRepository repository;
    protected final long revision;
    protected final SvnRepositoryExecutor repositoryExecutor;
    protected final Queue<Future<Pair<Void, SVNException>>> futures = new ConcurrentLinkedQueue<Future<Pair<Void, SVNException>>>();

    protected SvnQueryTaskBase(SVNRepository repository, long revision, SvnRepositoryExecutor repositoryExecutor) {
        this.repository = repository;
        this.revision = revision;
        this.repositoryExecutor = repositoryExecutor;
    }

    protected void waitForTasks() throws SVNException {
        while (!this.futures.isEmpty()) {
            Future<Pair<Void, SVNException>> future = this.futures.poll();
            try {
                SVNException exception = (SVNException)((Object)future.get().getSecond());
                if (exception == null) continue;
                throw exception;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AssertionError("Unexpected exception: " + e.getMessage(), e);
            }
        }
    }
}

