/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED}, valueClasses={String.class, Integer.class})
public class TfsRepositoryInfoIndex
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    public static final String BASE_NAME = "tfs-repository-infos";
    private static final String LAST_SCAN_KEY = "last-scan";
    private static final String START_REVISION_KEY = "start-revision";
    private static final String END_REVISION_KEY = "end-revision";
    private static final String KNOWN_BRANCHES_KEY = "branches";
    private static final Logger LOGGER = LogManager.getLogger();

    public TfsRepositoryInfoIndex(IStore store) {
        super(store);
    }

    public void setKnownBranches(Collection<String> branches) throws StorageException {
        this.store.putWithString(KNOWN_BRANCHES_KEY, StorageUtils.serialize(new ArrayList(CollectionUtils.sort(branches))));
    }

    public Set<String> getKnownBranches() throws StorageException {
        HashSet<String> result = new HashSet<String>();
        ArrayList values = StorageUtils.deserializeStringList((byte[])this.store.getWithString(KNOWN_BRANCHES_KEY));
        if (values != null) {
            result.addAll(values);
        }
        return result;
    }

    public OptionalInt getLastScanRevision() throws StorageException {
        return this.getOptionalIntValue(LAST_SCAN_KEY);
    }

    public void setLastScanRevision(int revision) throws StorageException {
        LOGGER.info("Setting last scan revision to " + revision);
        this.store.putWithString(LAST_SCAN_KEY, ByteArrayUtils.intToByteArray((int)revision));
    }

    public void setStartRevision(int revision) throws StorageException {
        this.store.putWithString(START_REVISION_KEY, ByteArrayUtils.intToByteArray((int)revision));
    }

    public void setEndRevision(int revision) throws StorageException {
        this.store.putWithString(END_REVISION_KEY, ByteArrayUtils.intToByteArray((int)revision));
    }

    public OptionalInt getStartRevision() throws StorageException {
        return this.getOptionalIntValue(START_REVISION_KEY);
    }

    public OptionalInt getEndRevision() throws StorageException {
        return this.getOptionalIntValue(END_REVISION_KEY);
    }

    private OptionalInt getOptionalIntValue(String key) throws StorageException {
        byte[] value = this.store.getWithString(key);
        if (value != null) {
            return OptionalInt.of(ByteArrayUtils.byteArrayToInt((byte[])value));
        }
        return OptionalInt.empty();
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        LOGGER.info("Clearing TFS repository infos due to rollback");
        StorageUtils.clearStore((IStore)this.store);
    }
}

