/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.polarion;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.ICustomFieldsProvidingConnectorDescriptor;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemLinkRoleIndex;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemTypeIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionSessionException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionConnectorValidator;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionFieldsImporter;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import com.teamscale.index.requirements_tracing.triggers.polarion.PolarionSynchronizer;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@ConnectorDescriptor
public class PolarionRequirementsManagementToolConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase
implements ICustomFieldsProvidingConnectorDescriptor {
    public static final String INCLUDED_WORK_ITEM_TYPES_PARAMETER_NAME = "Included work item types";
    public static final String INCLUDED_WORK_ITEM_LINK_ROLES_PARAMETER_NAME = "Included work item link roles";
    public static final String CUSTOM_FIELD_IDS_PARAMETER_NAME = "custom-fields";
    public static final String PROJECT_ID_PARAMETER_NAME = "Project ID";
    private static final String CUSTOM_FIELDS_PARAMETER_NAME = "Custom Fields";
    private static final String WORK_ITEM_LINK_PATTERN_PARAMETER_NAME = "Work item link pattern";
    @ConfigExposed(name="Project ID", description="ID of the Polarion project to read requirements from")
    protected String polarionProjectId;
    @ConfigExposed(name="Specification space name", description="Location (relative to \"modules\" folder of the Polarion project) containing the specification.")
    protected String specItemSpaceName = "Requirements";
    @ConfigExposed(name="Document (module) ID(s)", description="Regular expressions that identify modules/documents containing the work items. This is relative to the document space.", multilineText=true)
    protected List<String> includedDocumentRegexps = Collections.singletonList("System Requirement Specification");
    @ConfigExposed(name="Included work item types", description="Work item types to read from Polarion documents. The work item types not specified here will be filtered out.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    protected PairList<String, String> includedWorkItemTypes = PairList.fromPairs((Pair)Pair.createPair((Object)"heading", (Object)"H"), (Pair[])new Pair[]{Pair.createPair((Object)"systemrequirement", (Object)"SR")});
    @ConfigExposed(name="Custom Fields", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Custom field IDs to be imported from Polarion.")
    private List<String> includedCustomFieldIds = new ArrayList<String>();
    @ConfigExposed(name="Included work item link roles", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Work item link roles to read from Polarion documents. The work item link roles not specified here will be filtered out. The parent role is included by default and is not needed to be listed here.")
    private List<String> includedWorkItemLinkRoles = new ArrayList<String>();
    @ConfigExposed(name="Remove deleted items", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Whether specification items deleted in Polarion should also be deleted in Teamscale. If enabled, the first poll per day will also check for specification items deleted in Polarion and removes them from Teamscale. In order to detect deleted specification items, every specification item id has to be fetched from the Polarion server. This can be a rather expensive operation, even when no specification items are deleted. Due to backwards compatibility, this is by default disabled.", changeRequiresReAnalysis=false)
    private boolean cleanupEnabled = false;
    @ConfigExposed(name="Work item link pattern", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Pattern to extract work item links from the HTML of a document. This is required, in order to correctly detect items, that are in the 'Recycle Bin' of a document. The Pattern must contain a group called 'workItemId', which matches the id of the referenced work item.", changeRequiresReAnalysis=false)
    private String workItemLinkPattern = "id=\"polarion_wiki macro name=module-workitem;params=((id=(?<workItemId>[^\"|]+))|[^\"])+\"";
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(this::validateAccountDetails, false);

    protected PolarionRequirementsManagementToolConnectorDescriptor() {
        super(ERequirementsManagementTool.POLARION);
        this.autoExpose();
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, this.getLastCleanupIndexName());
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return PolarionSynchronizer.class;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateNamedCapturingGroupInRegexPattern((String)this.workItemLinkPattern, (String)"workItemId", (String)WORK_ITEM_LINK_PATTERN_PARAMETER_NAME);
    }

    private void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        try (PolarionServiceClient polarionClient = new PolarionServiceClient(this.connectorIdentifier, new PolarionServiceClient.Credentials(url, username, password), 1);){
            PolarionConnectorValidator connectorValidator = new PolarionConnectorValidator(new PolarionDocumentLocation(this.polarionProjectId, this.specItemSpaceName, this.includedDocumentRegexps), (Collection<String>)this.includedWorkItemTypes.getFirstList(), polarionClient);
            connectorValidator.validateConnector();
        }
        catch (PolarionSessionException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("project-id", this.polarionProjectId);
        issueTrackerTriggerBuilder.setTriggerParameter("document-location", this.specItemSpaceName);
        issueTrackerTriggerBuilder.setTriggerParameter("document-ids", ITriggerParameter.of(this.includedDocumentRegexps));
        issueTrackerTriggerBuilder.setTriggerParameter(INCLUDED_WORK_ITEM_TYPES_PARAMETER_NAME, ITriggerParameter.of(this.includedWorkItemTypes));
        issueTrackerTriggerBuilder.setTriggerParameter(CUSTOM_FIELD_IDS_PARAMETER_NAME, ITriggerParameter.of(this.includedCustomFieldIds));
        issueTrackerTriggerBuilder.setTriggerParameter(INCLUDED_WORK_ITEM_LINK_ROLES_PARAMETER_NAME, ITriggerParameter.of(this.includedWorkItemLinkRoles));
        issueTrackerTriggerBuilder.setTriggerParameter("cleanup-enabled", this.cleanupEnabled);
        issueTrackerTriggerBuilder.setTriggerParameter("workItemLinkPattern", this.workItemLinkPattern);
        issueTrackerTriggerBuilder.renameIndex("work-item-cleanup-index", this.getLastCleanupIndexName());
    }

    private String getLastCleanupIndexName() {
        return WorkItemCleanupIndex.buildIndexName(this.connectorIdentifier);
    }

    @Override
    public List<ExternalToolIssueCustomField> fetchCustomFields() throws ConnectorValidationException {
        List list;
        block8: {
            super.validate();
            PolarionServiceClient polarionClient = this.createPolarionClient();
            try {
                PolarionFieldsImporter importer = this.createFieldsImporter(polarionClient);
                list = importer.retrieveCustomFieldDefinitions(this.includedWorkItemTypes.extractFirstList()).getValues();
                if (polarionClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (polarionClient != null) {
                        try {
                            polarionClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PolarionServerException | PolarionSessionException | InterruptedException e) {
                    throw new ConnectorValidationException("Failed to fetch custom fields.", (Throwable)e);
                }
            }
            polarionClient.close();
        }
        return list;
    }

    private PolarionFieldsImporter createFieldsImporter(PolarionServiceClient polarionClient) {
        return new PolarionFieldsImporter(this.polarionProjectId, polarionClient);
    }

    private PolarionServiceClient createPolarionClient() throws PolarionSessionException, ConnectorValidationException {
        return new PolarionServiceClient(this.connectorIdentifier, new PolarionServiceClient.Credentials(this.credentialsModule.resolveExternalCredentials(this.getContext().getExternalCredentialsProvider())), 1);
    }

    public List<PolarionWorkItemLinkRole> fetchPolarionWorkItemLinkRoles() throws ConnectorValidationException, PolarionSessionException, PolarionServerException, StorageException, InterruptedException {
        super.validate();
        PolarionWorkItemLinkRoleIndex index = (PolarionWorkItemLinkRoleIndex)this.getContext().getIndexLayer().openGlobalIndex(PolarionWorkItemLinkRoleIndex.class);
        try (PolarionServiceClient polarionClient = this.createPolarionClient();){
            PolarionFieldsImporter importer = this.createFieldsImporter(polarionClient);
            List<PolarionWorkItemLinkRole> list = importer.retrieveAndStorePolarionWorkItemLinkRoles(index, true);
            return list;
        }
    }

    public List<PolarionWorkItemType> fetchPolarionWorkItemTypes() throws ConnectorValidationException, PolarionSessionException, PolarionServerException, StorageException, InterruptedException {
        super.validate();
        PolarionWorkItemTypeIndex index = (PolarionWorkItemTypeIndex)this.getContext().getIndexLayer().openGlobalIndex(PolarionWorkItemTypeIndex.class);
        try (PolarionServiceClient polarionClient = this.createPolarionClient();){
            PolarionFieldsImporter importer = this.createFieldsImporter(polarionClient);
            List<PolarionWorkItemType> list = importer.retrieveAndStorePolarionWorkItemTypes(index, true);
            return list;
        }
    }
}

