/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="work-item-types", options={EStorageOption.NO_ROLLBACK})
public class PolarionWorkItemTypeIndex
implements IGlobalIndex {
    private final ValueIndex<ArrayList<PolarionWorkItemType>> delegate;

    public PolarionWorkItemTypeIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storeWorkItemTypes(String projectId, List<PolarionWorkItemType> workItemTypes) throws StorageException {
        this.delegate.setValue(PolarionWorkItemTypeIndex.buildPolarionIndexKey(projectId), new ArrayList<PolarionWorkItemType>(workItemTypes));
    }

    private static String buildPolarionIndexKey(String projectId) {
        return ERequirementsManagementTool.POLARION.getReadableName().toLowerCase() + "#" + projectId;
    }

    public List<PolarionWorkItemType> getWorkItemTypes(String projectId) throws StorageException {
        return (List)this.delegate.getValue(PolarionWorkItemTypeIndex.buildPolarionIndexKey(projectId));
    }
}

