/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.WiaUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Index(name="temp-spec-items", options={EStorageOption.COMPRESSED}, valueClasses={WorkItemChange.class})
public class TempWorkItemIndex
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    public static final String INDEX_NAME = "temp-spec-items";
    private static final String LAST_CHANGE_TIMESTAMP_KEY = "###last-change-timestamp-key###";

    public TempWorkItemIndex(IStore store) {
        super(store);
    }

    public static String getIndexNameForRepository(String repositoryIdentifier) {
        return repositoryIdentifier + "-temp-spec-items";
    }

    private static String getRepositoryIdentifierFromIndexName(String indexName) {
        return StringUtils.stripSuffix((String)indexName, (String)"-temp-spec-items");
    }

    public void storeChangesForCommit(CommitDescriptor commit, Collection<WorkItemChange> changes) throws StorageException {
        this.store.put(TempWorkItemIndex.createCommitKey(commit), StorageUtils.serialize(new ArrayList<WorkItemChange>(changes)));
    }

    public void removeChangesForCommit(CommitDescriptor commit) throws StorageException {
        this.store.remove(TempWorkItemIndex.createCommitKey(commit));
    }

    private static byte[] createCommitKey(CommitDescriptor commit) {
        return commit.toBranchTimestampKeyWithSeparator();
    }

    public List<WorkItemChange> getChangesForCommit(CommitDescriptor commit) throws StorageException {
        byte[] value = this.store.get(TempWorkItemIndex.createCommitKey(commit));
        if (value == null) {
            return Collections.emptyList();
        }
        return (List)((Object)StorageUtils.deserialize((byte[])value));
    }

    public List<CommitDescriptor> getAllCommits() throws StorageException {
        ArrayList keys = new ArrayList();
        this.store.scanKeys("", (IKeyValueCallback)new KeyCollectingCallback(keys));
        byte[] lastChangeTimestampKeyBytes = StringUtils.stringToBytes((String)LAST_CHANGE_TIMESTAMP_KEY);
        return keys.stream().filter(key -> !Arrays.equals(key, lastChangeTimestampKeyBytes)).map(CommitDescriptor::fromBranchTimestampKeyWithSeparator).filter(commit -> !commit.getBranchName().startsWith("__WorkItemChangeCache__")).toList();
    }

    public WorkItemChangeCacheFactory getWorkItemChangeCacheFactory() {
        return new WorkItemChangeCacheFactory();
    }

    @VisibleForTesting
    public <T extends TeamscaleIssue> Set<T> getAllItems(Class<T> itemType, Instant until) throws StorageException {
        List<CommitDescriptor> allCommits = this.getAllCommits().stream().filter(commit -> commit.getTimestamp() < until.toEpochMilli()).toList();
        HashMap itemForId = new HashMap();
        for (CommitDescriptor commit2 : allCommits) {
            this.extractWorkItemChangeFromCommit(itemForId, itemType, commit2);
        }
        return new HashSet(itemForId.values());
    }

    @VisibleForTesting
    public <T extends TeamscaleIssue> @Nullable T getItem(Class<T> itemType, TeamscaleIssueId id, Instant until) throws StorageException {
        List<CommitDescriptor> commits = this.getAllCommits().stream().filter(commit -> commit.getTimestamp() < until.toEpochMilli()).sorted(Comparator.reverseOrder()).toList();
        for (CommitDescriptor commit2 : commits) {
            List<WorkItemChange> changes = this.getChangesForCommit(commit2);
            for (WorkItemChange change : changes) {
                if (!id.equals((Object)change.getWorkItemId())) continue;
                return (T)(switch (change.getChangeType().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> (TeamscaleIssue)itemType.cast(change.getUpdatedItem());
                    case 1 -> null;
                });
            }
        }
        return null;
    }

    private <T> void extractWorkItemChangeFromCommit(Map<TeamscaleIssueId, T> itemForId, Class<T> itemType, CommitDescriptor commit) throws StorageException {
        List<WorkItemChange> changes = this.getChangesForCommit(commit);
        for (WorkItemChange change : changes) {
            TempWorkItemIndex.handleWorkItemChange(itemForId, itemType, change);
        }
    }

    private static <T> void handleWorkItemChange(Map<TeamscaleIssueId, T> itemForId, Class<T> itemType, WorkItemChange change) {
        switch (change.getChangeType().ordinal()) {
            case 0: {
                TeamscaleIssue updatedItem = change.getUpdatedItem();
                if (!itemType.equals(updatedItem.getClass())) break;
                itemForId.put(change.getWorkItemId(), itemType.cast(updatedItem));
                break;
            }
            case 1: {
                itemForId.remove(change.getWorkItemId());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected value: " + String.valueOf((Object)change.getChangeType()));
            }
        }
    }

    public OptionalLong getLastChange() throws StorageException {
        byte[] value = this.store.getWithString(LAST_CHANGE_TIMESTAMP_KEY);
        if (value == null) {
            return OptionalLong.empty();
        }
        long millis = ByteArrayUtils.byteArrayToLong((byte[])value);
        return OptionalLong.of(millis);
    }

    public void setLastChange(Long lastChange) throws StorageException {
        if (lastChange == null) {
            this.store.removeWithString(LAST_CHANGE_TIMESTAMP_KEY);
        } else {
            byte[] value = ByteArrayUtils.longToByteArray((long)lastChange);
            this.store.putWithString(LAST_CHANGE_TIMESTAMP_KEY, value);
        }
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        String connectorId = TempWorkItemIndex.getRepositoryIdentifierFromIndexName(this.getName());
        String managedBranch = WiaUtils.getWorkItemConnectorBranchName((String)connectorId);
        Long rollbackTimestamp = timestampByBranch.get(managedBranch);
        if (rollbackTimestamp == null) {
            return;
        }
        List<CommitDescriptor> allCommits = this.getAllCommits();
        long newLastChangeTimestamp = -rollbackTimestamp.longValue();
        for (CommitDescriptor commitDescriptor : allCommits) {
            if (commitDescriptor.getTimestamp() > rollbackTimestamp) {
                this.removeChangesForCommit(commitDescriptor);
                continue;
            }
            newLastChangeTimestamp = Math.max(commitDescriptor.getTimestamp(), newLastChangeTimestamp);
        }
        this.setLastChange(newLastChangeTimestamp);
    }

    public final class WorkItemChangeCacheFactory {
        private static final String CACHE_BRANCH_PREFIX = "__WorkItemChangeCache__";
        private final String baseBranch = "__WorkItemChangeCache__" + String.valueOf(UUID.randomUUID());
        private final AtomicInteger cacheIndex = new AtomicInteger();

        public WorkItemChangeCache createCache() {
            return new WorkItemChangeCache(this.getNextBranch());
        }

        private String getNextBranch() {
            return this.baseBranch + "_" + this.cacheIndex.getAndIncrement();
        }

        public void clearCaches() throws StorageException {
            TempWorkItemIndex.this.store.removeByPrefix(this.baseBranch);
        }
    }

    @IndexValueClass
    public static abstract sealed class WorkItemChange
    implements Serializable
    permits WorkItemUpdate, WorkItemDeletion {
        private static final long serialVersionUID = 1L;
        private final EType changeType;
        private final @Nullable String author;

        protected WorkItemChange(EType changeType, @Nullable String author) {
            this.changeType = changeType;
            this.author = author;
        }

        public abstract TeamscaleIssueId getWorkItemId();

        public TeamscaleIssue getUpdatedItem() {
            throw new UnsupportedOperationException();
        }

        public long getDeletionTimestamp() {
            throw new UnsupportedOperationException();
        }

        public EType getChangeType() {
            return this.changeType;
        }

        public Optional<String> getAuthor() {
            return Optional.ofNullable(this.author);
        }

        @IndexValueClass
        public static enum EType {
            UPDATE,
            DELETION;

        }
    }

    public final class WorkItemChangeCache {
        public static final int MAXIMUM_CACHED_CHANGES = 100000;
        private final String branch;
        private final NavigableMap<Long, Integer> allTimestampsWithCount = new TreeMap<Long, Integer>();
        private final Map<Long, ArrayList<WorkItemChange>> cachedChanges = new HashMap<Long, ArrayList<WorkItemChange>>();
        private int cachedChangesSize = 0;
        private boolean frozen;

        private WorkItemChangeCache(String branch) {
            this.branch = branch;
        }

        public boolean isEmpty() {
            return this.allTimestampsWithCount.isEmpty();
        }

        public synchronized void addChanges(Map<Long, ? extends Collection<? extends WorkItemChange>> changes) throws StorageException {
            this.validateNotFrozen();
            for (Map.Entry<Long, ? extends Collection<? extends WorkItemChange>> change : changes.entrySet()) {
                long timestamp = change.getKey();
                Collection<? extends WorkItemChange> changesForTimestamp = change.getValue();
                if (changesForTimestamp.isEmpty()) continue;
                if (!this.allTimestampsWithCount.containsKey(timestamp)) {
                    this.cachedChanges.put(timestamp, new ArrayList<WorkItemChange>(changesForTimestamp));
                } else {
                    ArrayList<WorkItemChange> target = this.cachedChanges.get(timestamp);
                    if (target == null) {
                        target = this.getPersistedChanges(timestamp);
                        this.cachedChangesSize += target.size();
                        this.cachedChanges.put(timestamp, target);
                    }
                    target.addAll(changesForTimestamp);
                }
                this.cachedChangesSize += changesForTimestamp.size();
                this.allTimestampsWithCount.merge(timestamp, changesForTimestamp.size(), Integer::sum);
            }
            if (this.cachedChangesSize > 100000) {
                this.persistCachedChanges();
            }
        }

        public synchronized NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> getChanges() throws StorageException {
            if (this.anythingWasPersisted()) {
                this.persistCachedChanges();
            }
            TreeMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> result = new TreeMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>>();
            Iterator iterator = this.allTimestampsWithCount.keySet().iterator();
            while (iterator.hasNext()) {
                long timestamp = (Long)iterator.next();
                result.put(timestamp, (SupplierWithException<List<WorkItemChange>, StorageException>)((SupplierWithException)() -> {
                    WorkItemChangeCache workItemChangeCache = this;
                    synchronized (workItemChangeCache) {
                        List cached = this.cachedChanges.get(timestamp);
                        if (cached != null) {
                            return new ArrayList(cached);
                        }
                        return new ArrayList<WorkItemChange>(this.loadAndPrefetchCache(timestamp));
                    }
                }));
            }
            return result;
        }

        private boolean anythingWasPersisted() {
            return this.cachedChanges.size() != this.allTimestampsWithCount.size();
        }

        private List<WorkItemChange> loadAndPrefetchCache(long timestamp) throws StorageException {
            boolean descending = this.shouldPrefetchDescending(timestamp);
            this.cachedChanges.clear();
            this.cachedChangesSize = 0;
            ArrayList<Long> timestampsToFetch = new ArrayList<Long>();
            timestampsToFetch.add(timestamp);
            int elementsToPrefetch = (Integer)this.allTimestampsWithCount.get(timestamp);
            for (Map.Entry possibleTimestampsToPrefetch : this.getNextElementsToPrefetch(timestamp, descending).entrySet()) {
                if (elementsToPrefetch + (Integer)possibleTimestampsToPrefetch.getValue() > 100000) break;
                timestampsToFetch.add((Long)possibleTimestampsToPrefetch.getKey());
                elementsToPrefetch += ((Integer)possibleTimestampsToPrefetch.getValue()).intValue();
            }
            List<ArrayList<WorkItemChange>> persistedChanges = this.getPersistedChanges(timestampsToFetch);
            CollectionUtils.forEach(timestampsToFetch, persistedChanges, (timestamp1, changes) -> {
                this.cachedChanges.put((Long)timestamp1, (ArrayList<WorkItemChange>)changes);
                this.cachedChangesSize += changes.size();
            });
            return this.cachedChanges.get(timestamp);
        }

        private NavigableMap<Long, Integer> getNextElementsToPrefetch(long timestamp, boolean descending) {
            NavigableMap<Long, Integer> timestampWithCountForPrefetch = this.allTimestampsWithCount;
            if (descending) {
                timestampWithCountForPrefetch = this.allTimestampsWithCount.descendingMap();
            }
            return timestampWithCountForPrefetch.tailMap(timestamp, false);
        }

        private boolean shouldPrefetchDescending(long timestamp) {
            if (!this.cachedChanges.isEmpty()) {
                return this.cachedChanges.keySet().iterator().next() > timestamp;
            }
            return this.allTimestampsWithCount.ceilingEntry(timestamp + 1L) == null;
        }

        public synchronized void freeze() {
            this.frozen = true;
        }

        private void validateNotFrozen() {
            if (this.frozen) {
                throw new IllegalStateException("Frozen cache cannot be modified anymore");
            }
        }

        private void persistCachedChanges() throws StorageException {
            PairList keysAndValues = new PairList(this.cachedChanges.size());
            for (Map.Entry<Long, ArrayList<WorkItemChange>> entry : this.cachedChanges.entrySet()) {
                keysAndValues.add((Object)this.createKey(entry.getKey()), (Object)StorageUtils.serialize((Serializable)entry.getValue()));
            }
            TempWorkItemIndex.this.store.put(keysAndValues);
            this.cachedChanges.clear();
            this.cachedChangesSize = 0;
        }

        private ArrayList<WorkItemChange> getPersistedChanges(long timestamp) throws StorageException {
            return (ArrayList)StorageUtils.deserialize((byte[])TempWorkItemIndex.this.store.get(this.createKey(timestamp)));
        }

        private List<ArrayList<WorkItemChange>> getPersistedChanges(List<Long> timestamps) throws StorageException {
            List<byte[]> keys = timestamps.stream().map(this::createKey).toList();
            List values = TempWorkItemIndex.this.store.get(keys);
            ArrayList<ArrayList<WorkItemChange>> result = new ArrayList<ArrayList<WorkItemChange>>(values.size());
            for (byte[] value : values) {
                result.add((ArrayList)StorageUtils.deserialize((byte[])value));
            }
            return result;
        }

        private byte[] createKey(long timestamp) {
            return TempWorkItemIndex.createCommitKey(new CommitDescriptor(this.branch, timestamp));
        }
    }

    @IndexValueClass
    public static final class WorkItemDeletion
    extends WorkItemChange {
        private static final long serialVersionUID = 1L;
        private final TeamscaleIssueId workItemId;
        private final long deletionTimestamp;

        public WorkItemDeletion(TeamscaleIssueId workItemId, long deletionTimestamp) {
            this(workItemId, deletionTimestamp, null);
        }

        public WorkItemDeletion(TeamscaleIssueId workItemId, long deletionTimestamp, @Nullable String author) {
            super(WorkItemChange.EType.DELETION, author);
            CCSMAssert.isNotNull((Object)workItemId, () -> String.format("Expected \"%s\" to be not null", "workItemId"));
            this.workItemId = workItemId;
            this.deletionTimestamp = deletionTimestamp;
        }

        @Override
        public TeamscaleIssueId getWorkItemId() {
            return this.workItemId;
        }

        @Override
        public long getDeletionTimestamp() {
            return this.deletionTimestamp;
        }

        public String toString() {
            return "WorkItemDeletion{workItemId=" + String.valueOf(this.workItemId) + ", deletionTimestamp=" + this.deletionTimestamp + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkItemDeletion that = (WorkItemDeletion)o;
            return this.deletionTimestamp == that.deletionTimestamp && Objects.equals(this.workItemId, that.workItemId);
        }

        public int hashCode() {
            return Objects.hash(this.workItemId, this.deletionTimestamp);
        }
    }

    @IndexValueClass
    public static final class WorkItemUpdate
    extends WorkItemChange {
        private static final long serialVersionUID = 1L;
        private final TeamscaleIssue updatedItem;

        public WorkItemUpdate(TeamscaleIssue updatedItem) {
            this(updatedItem, null);
        }

        public WorkItemUpdate(TeamscaleIssue updatedItem, @Nullable String author) {
            super(WorkItemChange.EType.UPDATE, author);
            CCSMAssert.isNotNull((Object)updatedItem, () -> String.format("Expected \"%s\" to be not null", "updatedItem"));
            this.updatedItem = updatedItem;
        }

        @Override
        public TeamscaleIssueId getWorkItemId() {
            return this.updatedItem.getId();
        }

        @Override
        public TeamscaleIssue getUpdatedItem() {
            return this.updatedItem;
        }

        public String toString() {
            return "WorkItemUpdate{updatedItem=" + String.valueOf(this.updatedItem) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkItemUpdate that = (WorkItemUpdate)o;
            return Objects.equals(this.updatedItem, that.updatedItem);
        }

        public int hashCode() {
            return Objects.hash(this.updatedItem);
        }
    }
}

