/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request.ambiguity_resolution;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculatorUtils;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemReferenceDiff;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.utils.DiffUtils;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;

public class EntitySignatureComparingStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, TokenElementInfo> tokenElementsByUniformPathAtMergeBase;
    private final Map<String, TokenElementInfo> tokenElementsByUniformPathAtSourceHead;
    private final CommitDescriptor sourceHeadCommit;
    private final CommitDescriptor mergeBaseCommit;
    private final Map<TeamscaleIssueId, TeamscaleIssueTypeInfo> specItemTypeInfoById;

    public EntitySignatureComparingStrategy(Map<String, TokenElementInfo> tokenElementsByUniformPathAtMergeBase, Map<String, TokenElementInfo> tokenElementsByUniformPathAtSourceHead, CommitDescriptor sourceHeadCommit, CommitDescriptor mergeBaseCommit, Map<TeamscaleIssueId, TeamscaleIssueTypeInfo> specItemTypeInfoById) {
        this.tokenElementsByUniformPathAtMergeBase = tokenElementsByUniformPathAtMergeBase;
        this.tokenElementsByUniformPathAtSourceHead = tokenElementsByUniformPathAtSourceHead;
        this.sourceHeadCommit = sourceHeadCommit;
        this.mergeBaseCommit = mergeBaseCommit;
        this.specItemTypeInfoById = specItemTypeInfoById;
    }

    public Set<SpecItemCodeReference> getSpecItemReferenceIntersection(String uniformPath, TeamscaleIssueId specItemId, Set<SpecItemCodeReference> referencesAtSourceHead, Set<SpecItemCodeReference> referencesAtMergeBase, List<SpecItemReferenceDiff> referencesInChangedCode) {
        HashSet<SpecItemCodeReference> specItemCodeReferenceIntersection = new HashSet<SpecItemCodeReference>();
        if (referencesAtSourceHead == null || referencesAtMergeBase == null) {
            return specItemCodeReferenceIntersection;
        }
        for (SpecItemCodeReference reqCodeReferenceAtSourceHead : referencesAtSourceHead) {
            for (SpecItemCodeReference reqCodeReferenceAtMergeBase : referencesAtMergeBase) {
                if (!MergeRequestImpactedSpecItemsCalculatorUtils.isSignatureEqual(reqCodeReferenceAtSourceHead, reqCodeReferenceAtMergeBase)) continue;
                specItemCodeReferenceIntersection.add(reqCodeReferenceAtMergeBase);
                specItemCodeReferenceIntersection.add(reqCodeReferenceAtSourceHead);
                if (!this.determineIfReferenceIsChangedInSourceHead(uniformPath, reqCodeReferenceAtSourceHead)) continue;
                referencesInChangedCode.add(new SpecItemReferenceDiff(uniformPath, specItemId, reqCodeReferenceAtSourceHead.getCommentLineNumber(), reqCodeReferenceAtMergeBase.getCommentLineNumber(), this.sourceHeadCommit, this.mergeBaseCommit, reqCodeReferenceAtSourceHead.getReferencedShallowEntity(), reqCodeReferenceAtMergeBase.getReferencedShallowEntity(), reqCodeReferenceAtSourceHead.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.MODIFIED, this.specItemTypeInfoById.get(specItemId)));
            }
        }
        return specItemCodeReferenceIntersection;
    }

    private boolean determineIfReferenceIsChangedInSourceHead(String uniformPath, SpecItemCodeReference reqCodeReferenceAtSourceHead) {
        SpecItemCodeReference.ReferencedShallowEntity specItemCodeEntityAtSourceHead = reqCodeReferenceAtSourceHead.getReferencedNonPreprocessedShallowEntity();
        TokenElementInfo oldElement = this.tokenElementsByUniformPathAtMergeBase.get(uniformPath);
        TokenElementInfo newElement = this.tokenElementsByUniformPathAtSourceHead.get(uniformPath);
        try {
            return DiffUtils.isChanged(new TextRegionLocation(uniformPath, specItemCodeEntityAtSourceHead.getStartOffset(), specItemCodeEntityAtSourceHead.getEndOffset(), specItemCodeEntityAtSourceHead.getStartLine(), specItemCodeEntityAtSourceHead.getEndLine()), oldElement, newElement);
        }
        catch (DiffUtils.DiffComputationException e) {
            LOGGER.error("Unable to determine if spec item reference entity changed: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

