/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.teamscale.core.log.interaction.InteractionLogMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;

class PolarionLogHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final String RESPONSE_SIZE_WARNING_THRESHOLD = System.getProperty("com.teamscale.polarion.response_size_warning_threshold", "1 MiB");
    private static final long PARSED_RESPONSE_SIZE_WARNING_THRESHOLD = ByteUnit.parseUnitMeasurementAs((String)RESPONSE_SIZE_WARNING_THRESHOLD, (ByteUnit)ByteUnit.BYTES);
    private static final Logger LOGGER = LogManager.getLogger();

    PolarionLogHandler() {
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getResponseMessage() != null && msgContext.getResponseMessage().getSOAPPart() != null) {
            PolarionLogHandler.logResponseMessage(msgContext);
        }
    }

    private static void logResponseMessage(MessageContext msgContext) throws AxisFault {
        Message responseMessage = msgContext.getResponseMessage();
        long responseSize = responseMessage.getContentLength();
        if (responseSize >= PARSED_RESPONSE_SIZE_WARNING_THRESHOLD) {
            String message = "Response size (%d KiB) exceeded configured threshold (%s)\nRequest=%s".formatted(ByteUnit.BYTES.toKibiBytes(responseSize), RESPONSE_SIZE_WARNING_THRESHOLD, msgContext.getRequestMessage().getSOAPPartAsString());
            String targetUrl = String.valueOf(msgContext.getProperty("transport.url"));
            LOGGER.warn(LoggingUtils.INTERACTION, (org.apache.logging.log4j.message.Message)new InteractionLogMessage(message, targetUrl, ""));
            if (LOGGER.isDebugEnabled()) {
                String debugLogMessage = message + "\nResponse=" + responseMessage.getSOAPPartAsString();
                LOGGER.debug((org.apache.logging.log4j.message.Message)new InteractionLogMessage(debugLogMessage, targetUrl, ""));
            }
        }
    }
}

