/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer;

import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemField;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class PolarionImportConfiguration {
    public static final int MAXIMUM_PARALLELISM = Integer.getInteger("com.teamscale.polarion.maximum_parallelism", Runtime.getRuntime().availableProcessors());
    private final PolarionDocumentLocation polarionDocumentLocation;
    private final PolarionServiceClient serviceClient;
    public static final String POLARION_WORK_ITEM_PARENT_LINK_ROLE_ID = "parent";
    private final Map<String, String> includedWorkItemTypeIdToName;
    private final Map<String, String> includedWorkItemTypeIdToAbbreviation;
    private final CustomFieldConfiguration customFieldConfiguration;
    private final List<PolarionWorkItemLinkRole> polarionWorkItemLinkRoles;
    private final List<String> includedWorkItemLinkRoles;
    private final Map<String, PolarionWorkItemLinkRole> resolvedIncludedWorkItemLinkRoles;
    private final String connectorId;
    private final Instant initialTimestamp;
    private final Pattern workItemLinkPattern;
    private final IWorkItemCleanupStrategy cleanupStrategy;

    public PolarionImportConfiguration(PolarionDocumentLocation polarionDocumentLocation, PolarionServiceClient serviceClient, List<PolarionWorkItemType> workItemTypes, CustomFieldConfiguration customFieldConfiguration, List<PolarionWorkItemLinkRole> polarionWorkItemLinkRoles, List<String> includedWorkItemLinkRoles, String connectorId, Instant initialTimestamp, Pattern workItemLinkPattern, IWorkItemCleanupStrategy cleanupStrategy) {
        this.polarionDocumentLocation = polarionDocumentLocation;
        this.serviceClient = serviceClient;
        this.includedWorkItemTypeIdToName = PolarionImportConfiguration.buildIdToNameMap(workItemTypes);
        this.includedWorkItemTypeIdToAbbreviation = PolarionImportConfiguration.buildIdToAbbreviationMap(workItemTypes);
        this.customFieldConfiguration = customFieldConfiguration;
        this.polarionWorkItemLinkRoles = polarionWorkItemLinkRoles;
        this.connectorId = connectorId;
        this.initialTimestamp = initialTimestamp;
        this.workItemLinkPattern = workItemLinkPattern;
        this.cleanupStrategy = cleanupStrategy;
        this.includedWorkItemLinkRoles = new ArrayList<String>();
        this.resolvedIncludedWorkItemLinkRoles = new LinkedHashMap<String, PolarionWorkItemLinkRole>();
        this.resolveIncludedWorkItemLinkRoles(includedWorkItemLinkRoles);
    }

    private static Map<String, String> buildIdToNameMap(List<PolarionWorkItemType> workItemTypes) {
        HashMap<String, String> includedWorkItemTypeIdToName = new HashMap<String, String>();
        for (PolarionWorkItemType workItemType : workItemTypes) {
            includedWorkItemTypeIdToName.put(workItemType.getId(), workItemType.getName());
        }
        return includedWorkItemTypeIdToName;
    }

    private static Map<String, String> buildIdToAbbreviationMap(List<PolarionWorkItemType> workItemTypes) {
        HashMap<String, String> includedWorkItemTypeIdToAbbreviation = new HashMap<String, String>();
        for (PolarionWorkItemType workItemType : workItemTypes) {
            includedWorkItemTypeIdToAbbreviation.put(workItemType.getId(), workItemType.getAbbreviation());
        }
        return includedWorkItemTypeIdToAbbreviation;
    }

    public String[] getAllFieldIdsToBeFetched() {
        List<String> fieldIds = EPolarionDefaultWorkItemField.valuesAsList();
        fieldIds.addAll(this.customFieldConfiguration.getResolvedCustomFieldIds());
        return (String[])fieldIds.toArray(String[]::new);
    }

    public Map<String, String> getIncludedWorkItemTypeIdToName() {
        return Collections.unmodifiableMap(this.includedWorkItemTypeIdToName);
    }

    public CustomFieldConfiguration getCustomFieldConfiguration() {
        return this.customFieldConfiguration;
    }

    public List<String> getIncludedPolarionWorkItemLinkRoles() {
        return Collections.unmodifiableList(this.includedWorkItemLinkRoles);
    }

    public UnmodifiableMap<String, PolarionWorkItemLinkRole> getResolvedIncludedPolarionWorkItemLinkRoles() {
        return CollectionUtils.asUnmodifiable(this.resolvedIncludedWorkItemLinkRoles);
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    private void resolveIncludedWorkItemLinkRoles(List<String> includedWorkItemLinkRoles) {
        HashSet<String> includedWorkItemLinkRolesSet = new HashSet<String>(includedWorkItemLinkRoles);
        for (PolarionWorkItemLinkRole linkRole : this.polarionWorkItemLinkRoles) {
            if (linkRole.getId().equals(POLARION_WORK_ITEM_PARENT_LINK_ROLE_ID)) {
                this.resolvedIncludedWorkItemLinkRoles.put(linkRole.getId(), linkRole);
                this.includedWorkItemLinkRoles.add(linkRole.getName());
                this.includedWorkItemLinkRoles.add(linkRole.getOppositeName());
                continue;
            }
            String name = null;
            String oppositeName = null;
            if (includedWorkItemLinkRolesSet.contains(linkRole.getName())) {
                name = linkRole.getName();
                this.includedWorkItemLinkRoles.add(linkRole.getName());
            }
            if (includedWorkItemLinkRolesSet.contains(linkRole.getOppositeName())) {
                oppositeName = linkRole.getOppositeName();
                this.includedWorkItemLinkRoles.add(linkRole.getOppositeName());
            }
            if (name == null && oppositeName == null) continue;
            this.resolvedIncludedWorkItemLinkRoles.put(linkRole.getId(), new PolarionWorkItemLinkRole(linkRole.getId(), name, oppositeName));
        }
    }

    public PolarionDocumentLocation getPolarionDocumentLocation() {
        return this.polarionDocumentLocation;
    }

    public Map<String, String> getIncludedWorkItemTypeIdToAbbreviation() {
        return this.includedWorkItemTypeIdToAbbreviation;
    }

    public Instant getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public PolarionServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public Pattern getWorkItemLinkPattern() {
        return this.workItemLinkPattern;
    }

    public IWorkItemCleanupStrategy getCleanupStrategy() {
        return this.cleanupStrategy;
    }

    public static class CustomFieldConfiguration {
        private static final String CUSTOM_FIELD_ID_PREFIX = "customFields.";
        private final TwoDimHashMap<String, String, ExternalToolIssueCustomField> polarionCustomFields;
        private final List<String> includedCustomFieldIds;
        private final Set<String> ignoredFields;

        public CustomFieldConfiguration(TwoDimHashMap<String, String, ExternalToolIssueCustomField> polarionCustomFields, List<String> includedCustomFieldIds) {
            this.polarionCustomFields = polarionCustomFields;
            this.includedCustomFieldIds = includedCustomFieldIds;
            this.ignoredFields = CustomFieldConfiguration.computeIgnoredFields(this.getPolarionCustomFieldIds());
        }

        private static Set<String> computeIgnoredFields(Set<String> allCustomFieldIds) {
            HashSet<String> ignoredFields = new HashSet<String>(allCustomFieldIds);
            for (EPolarionDefaultWorkItemField defaultField : EPolarionDefaultWorkItemField.values()) {
                if (defaultField == EPolarionDefaultWorkItemField.UPDATED || defaultField == EPolarionDefaultWorkItemField.LINKED_WORK_ITEMS) continue;
                ignoredFields.add(defaultField.getPolarionFieldName());
            }
            return ignoredFields;
        }

        private Set<String> getPolarionCustomFieldIds() {
            return this.polarionCustomFields.getValues().stream().map(ExternalToolIssueCustomField::getId).collect(Collectors.toSet());
        }

        List<String> getResolvedCustomFieldIds() {
            Set<String> polarionCustomFieldIds = this.getPolarionCustomFieldIds();
            return this.includedCustomFieldIds.stream().filter(polarionCustomFieldIds::contains).map(id -> CUSTOM_FIELD_ID_PREFIX + id).collect(Collectors.toList());
        }

        public TwoDimHashMap<String, String, ExternalToolIssueCustomField> getPolarionCustomFields() {
            return this.polarionCustomFields;
        }

        public UnmodifiableSet<String> getIgnoredFields() {
            return CollectionUtils.asUnmodifiable(this.ignoredFields);
        }
    }
}

