/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.jira;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.jira.model.JiraJsonIssue;
import com.teamscale.index.issues.jira.synchronization.JiraIssueSynchronizer;
import com.teamscale.index.issues.jira.synchronization.JiraSynchronizerBase;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class JiraSpecItemSynchronizer
extends JiraSynchronizerBase<SpecItem> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SpecItemHistoryIndex specItemHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="spec-items")
    private SpecItemIndex previousSpecItemIndex;

    @Override
    protected IIssueHistoryIndex<SpecItem> getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousSpecItemIndex;
    }

    @Override
    protected SpecItem createIssue(JiraJsonIssue jiraIssue, String url, List<String> customFieldNames, List<String> customFieldValues, Map<String, String> typeToAbbreviation) {
        TeamscaleIssue issue = JiraIssueSynchronizer.createTeamscaleIssue(jiraIssue, this.connectorId, url, customFieldNames, customFieldValues);
        String type = "";
        String typeAbbreviation = "";
        if (issue.getAdditionalFieldValue("Type") != null) {
            type = issue.getAdditionalFieldValue("Type");
            typeAbbreviation = typeToAbbreviation.get(type);
        }
        return new SpecItem(JiraIssueSynchronizer.createTeamscaleIssue(jiraIssue, this.connectorId, url, customFieldNames, customFieldValues), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), type, typeAbbreviation);
    }

    @Override
    protected Map<TeamscaleIssueId, Long> performCleanupIfNecessary() {
        return Collections.emptyMap();
    }
}

