/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.SystemIncludeFileCacheEntry;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="system-included-directories-header-cache", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED})
public class SystemIncludeFileCacheIndex
implements IGlobalIndex {
    public static final String NAME = "system-included-directories-header-cache";
    private final ValueIndex<SystemIncludeFileCacheEntry> delegate;

    public SystemIncludeFileCacheIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void cacheTokens(PairList<String, List<IToken>> filePathsAndTokens) throws StorageException {
        PairList keysAndValues = (PairList)filePathsAndTokens.stream().map(SystemIncludeFileCacheIndex::createEntry).collect(PairList.toPairList());
        this.delegate.setValues(keysAndValues);
    }

    public Optional<List<IToken>> getCachedTokens(String filePath) throws StorageException {
        SystemIncludeFileCacheEntry storedEntry = (SystemIncludeFileCacheEntry)this.delegate.getValue(SystemIncludeFileCacheIndex.createKey(filePath));
        if (storedEntry == null) {
            return Optional.empty();
        }
        return Optional.of(storedEntry.tokens());
    }

    private static Pair<String, SystemIncludeFileCacheEntry> createEntry(Pair<String, List<IToken>> filePathAndToken) {
        return SystemIncludeFileCacheIndex.createEntry((String)filePathAndToken.getFirst(), (List)filePathAndToken.getSecond());
    }

    private static Pair<String, SystemIncludeFileCacheEntry> createEntry(String path, List<IToken> tokens) {
        String uniformPath = SystemIncludeFileCacheIndex.createKey(path);
        SystemIncludeFileCacheEntry value = new SystemIncludeFileCacheEntry(tokens);
        return Pair.createPair((Object)uniformPath, (Object)value);
    }

    private static String createKey(String path) {
        return UniformPathUtils.cleanPath((String)UniformPathUtils.normalizeAllSeparators((String)path));
    }
}

