/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.reparsing_dependency.IncludeRelations;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDependencyIndex;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorRerunDefineTreesIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.IfDirectivePreprocessor;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class PreprocessorIncludeReparseTrigger
extends ChangeProcessorAnalysisStep {
    public static final Set<ELanguage> RELEVANT_LANGUAGES = CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES;
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta basicContentIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicContentIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, indexName="reparsing-dependency")
    private List<PreprocessorIncludeReparsingDependencyIndex> parentReparsingDependencyIndices;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ReparseRequiredIndex reparseRequiredIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="preprocessor-rerun-relevant-define-trees")
    private PreprocessorRerunDefineTreesIndex parentPreprocessorRerunDefineTreesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PreprocessorRerunDefineTreesIndex preprocessorRerunDefineTreesIndex;

    public void execute() throws StorageException {
        List deletedUniformPaths = this.basicContentIndexDelta.getDeletedKeysAsStrings();
        List addedOrChangedUniformPaths = this.basicContentIndexDelta.getAddedOrChangedKeysAsStrings();
        Map<String, PreprocessorRerunDefineTreesIndex.DefineTree> defineTreesOfChangedPaths = this.computeDefineTreesUpdate(addedOrChangedUniformPaths);
        this.preprocessorRerunDefineTreesIndex.putUpdatedDefineTrees(defineTreesOfChangedPaths);
        this.preprocessorRerunDefineTreesIndex.remove(deletedUniformPaths);
        if (this.parentReparsingDependencyIndices.isEmpty()) {
            this.reparseRequiredIndex.storeAdditionalUniformPathsForReparsing(this.getSchedulingCommit(), Set.of(), Set.of());
            return;
        }
        List<String> deletedUniformPathsThatHadDefineTree = this.computeDeletedPathsThatHadADefineTree(deletedUniformPaths);
        List<String> pathsWithChangedDefineTree = this.computePathsWithChangedDefineTree(defineTreesOfChangedPaths);
        pathsWithChangedDefineTree.addAll(deletedUniformPathsThatHadDefineTree);
        ArrayList<String> allPotentiallyRelevantPaths = new ArrayList<String>(defineTreesOfChangedPaths.keySet());
        allPotentiallyRelevantPaths.addAll(deletedUniformPathsThatHadDefineTree);
        IncludeRelations includeRelations = PreprocessorIncludeReparseTrigger.determineTransitiveDependencyHull(allPotentiallyRelevantPaths, this.parentReparsingDependencyIndices);
        includeRelations.removeAll(addedOrChangedUniformPaths);
        includeRelations.removeAll(deletedUniformPaths);
        this.removeAllHiddenOrUnknownPaths(includeRelations);
        Set<String> additionalUniformPathsToBeReparsed = includeRelations.getPathsTransitivelyIncludingAnyOf(pathsWithChangedDefineTree);
        this.reparseRequiredIndex.storeAdditionalUniformPathsForReparsing(this.getSchedulingCommit(), additionalUniformPathsToBeReparsed, includeRelations.getIncludingUniformPaths());
    }

    private Map<String, PreprocessorRerunDefineTreesIndex.DefineTree> computeDefineTreesUpdate(List<String> allAddedOrChangedUniformPaths) throws StorageException {
        HashMap<String, PreprocessorRerunDefineTreesIndex.DefineTree> result = new HashMap<String, PreprocessorRerunDefineTreesIndex.DefineTree>();
        for (BasicTokenElementInfo element : this.basicContentIndex.getTokenElements(allAddedOrChangedUniformPaths)) {
            if (element == null || !CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(element.getLanguage())) continue;
            List tokens = ScannerUtils.getTokens((String)element.getText(), (ELanguage)element.getLanguage(), (String)element.getUniformPath());
            PreprocessorRerunDefineTreesIndex.DefineTree defineTree = new PreprocessorRerunDefineTreesIndex.DefineTree(PreprocessorIncludeReparseTrigger.extractDefineTreeFromCurrentCode(tokens));
            result.put(element.getUniformPath(), defineTree);
        }
        return result;
    }

    @VisibleForTesting
    public static String extractDefineTreeFromCurrentCode(List<IToken> tokens) {
        int indentation = 0;
        StringBuilder defineTree = new StringBuilder();
        for (IToken token : tokens) {
            String conditionText;
            List condition;
            if (CPreprocessor.isIncludeDirectiveToken((IToken)token)) {
                defineTree.repeat(" ", indentation).append(token.getLineNumber()).append(":").append(token.getOffset()).append(token.getText()).append("\n");
            }
            if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE) continue;
            String directiveText = CPreprocessor.stripHashAndBackslash((String)token.getText());
            if (directiveText.startsWith("define")) {
                MacroDefinition macroDefinition = MacroDefinition.parseMacroDefinition((String)directiveText.substring("define".length()), (TextRegionLocation)CPreprocessingUtils.locationFromToken((IToken)token), (ELanguage)token.getLanguage(), (boolean)false);
                defineTree.repeat(" ", indentation).append(token.getLineNumber()).append(":").append(token.getOffset());
                PreprocessorIncludeReparseTrigger.appendDefineRepresentation(macroDefinition, defineTree);
                defineTree.append("\n");
                continue;
            }
            if (directiveText.startsWith("undef")) {
                String macroName = directiveText.substring("undef".length()).trim();
                defineTree.repeat("  ", indentation).append("UNDEF ").append(macroName).append("\n");
                continue;
            }
            if (IfDirectivePreprocessor.isIfDirective((IToken)token)) {
                condition = IfDirectivePreprocessor.extractCondition((IToken)token);
                conditionText = TokenStreamTextUtils.concatTokenTexts((List)condition, (String)" ");
                defineTree.repeat(" ", indentation).append("IF ").append(conditionText).append("\n");
                ++indentation;
                continue;
            }
            if (IfDirectivePreprocessor.isElseDirective((IToken)token)) {
                defineTree.repeat(" ", Math.max(indentation - 1, 0)).append("ELSE").append("\n");
                continue;
            }
            if (IfDirectivePreprocessor.isElifDirective((IToken)token)) {
                condition = IfDirectivePreprocessor.extractCondition((IToken)token);
                conditionText = TokenStreamTextUtils.concatTokenTexts((List)condition, (String)" ");
                defineTree.repeat(" ", Math.max(indentation - 1, 0)).append("ELIF ").append(conditionText).append("\n");
                continue;
            }
            if (!IfDirectivePreprocessor.isEndIfDirective((IToken)token)) continue;
            indentation = Math.max(indentation - 1, 0);
            defineTree.repeat(" ", indentation).append("ENDIF").append("\n");
        }
        return defineTree.toString();
    }

    private static void appendDefineRepresentation(MacroDefinition macroDefinition, StringBuilder defineTree) {
        if (macroDefinition.isFunctionMacro) {
            defineTree.append(" DEFINE ").append(macroDefinition.macroName);
            defineTree.append("(").append(StringUtils.concat((Iterable)macroDefinition.parameterNames, (String)","));
            defineTree.append(") ").append(MacroDefinition.rebuildTextFromTokens((List)macroDefinition.replacementList));
        } else {
            defineTree.append(" DEFINE ").append(macroDefinition.macroName).append(" ").append(MacroDefinition.rebuildTextFromTokens((List)macroDefinition.replacementList));
        }
    }

    @VisibleForTesting
    public static IncludeRelations determineTransitiveDependencyHull(List<String> rootUniformPaths, List<PreprocessorIncludeReparsingDependencyIndex> parentReparsingDependencyIndices) throws StorageException {
        IncludeRelations includeRelationCollector = new IncludeRelations(rootUniformPaths);
        for (String uniformPath : rootUniformPaths) {
            Set<String> directlyDependentPaths = PreprocessorIncludeReparseTrigger.determineDirectlyDependentUniformPaths(uniformPath, parentReparsingDependencyIndices);
            includeRelationCollector.setIncludes(uniformPath, directlyDependentPaths);
        }
        HashSet<String> currentStep = new HashSet<String>(includeRelationCollector.getIncludingUniformPaths());
        while (!currentStep.isEmpty()) {
            HashSet nextStep = new HashSet();
            for (String uniformPath : currentStep) {
                Set<String> directlyIncludingPaths = PreprocessorIncludeReparseTrigger.determineDirectlyDependentUniformPaths(uniformPath, parentReparsingDependencyIndices);
                HashSet<String> includingPathsWithChangedInformation = new HashSet<String>();
                for (String directlyIncludingPath : directlyIncludingPaths) {
                    boolean informationChanged = includeRelationCollector.propagateIncludeRelation(uniformPath, directlyIncludingPath);
                    if (!informationChanged) continue;
                    includingPathsWithChangedInformation.add(directlyIncludingPath);
                }
                nextStep.addAll(includingPathsWithChangedInformation);
            }
            currentStep = nextStep;
        }
        return includeRelationCollector;
    }

    private static Set<String> determineDirectlyDependentUniformPaths(String uniformPath, List<PreprocessorIncludeReparsingDependencyIndex> parentReparsingDependencyIndices) throws StorageException {
        String fileNames = PreprocessorIncludeReparsingDependencyIndex.buildDependencyTargetStorageKeyForUniformPath(uniformPath);
        HashSet<String> dependentUniformPaths = new HashSet<String>();
        for (PreprocessorIncludeReparsingDependencyIndex inverseIndex : parentReparsingDependencyIndices) {
            List<List<String>> uniformPathsIncludingFileNames = inverseIndex.getPathsIncludingFileNames(List.of(fileNames));
            if (uniformPathsIncludingFileNames.isEmpty() || uniformPathsIncludingFileNames.get(0) == null) continue;
            dependentUniformPaths.addAll((Collection<String>)uniformPathsIncludingFileNames.get(0));
        }
        return dependentUniformPaths;
    }

    private void removeAllHiddenOrUnknownPaths(IncludeRelations includeRelations) throws StorageException {
        Map<String, BasicTokenElementInfo> elements = this.basicContentIndex.getTokenElementsByPath(includeRelations.getIncludingUniformPaths());
        for (Map.Entry<String, BasicTokenElementInfo> entry : elements.entrySet()) {
            if (!entry.getValue().getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent()) continue;
            includeRelations.remove(entry.getKey());
        }
        includeRelations.removeIf(Predicate.not(elements::containsKey));
    }

    private @NonNull List<String> computePathsWithChangedDefineTree(Map<String, PreprocessorRerunDefineTreesIndex.DefineTree> currentDefineTreesOfChangedRelevantFiles) throws StorageException {
        ArrayList<String> addedOrChangedRelevantPaths = new ArrayList<String>(currentDefineTreesOfChangedRelevantFiles.keySet());
        ArrayList<String> pathsWithChangedDefineTree = new ArrayList<String>();
        Map<String, PreprocessorRerunDefineTreesIndex.DefineTree> parentDefineTrees = this.parentPreprocessorRerunDefineTreesIndex.getDefineTrees(addedOrChangedRelevantPaths);
        for (String path : addedOrChangedRelevantPaths) {
            if (parentDefineTrees.get(path) == null) {
                pathsWithChangedDefineTree.add(path);
                continue;
            }
            PreprocessorRerunDefineTreesIndex.DefineTree newDefineTrees = currentDefineTreesOfChangedRelevantFiles.get(path);
            if (newDefineTrees != null && newDefineTrees.defineTree().equals(parentDefineTrees.get(path).defineTree())) continue;
            pathsWithChangedDefineTree.add(path);
        }
        return pathsWithChangedDefineTree;
    }

    private List<String> computeDeletedPathsThatHadADefineTree(List<String> deletedUniformPaths) throws StorageException {
        if (this.parentReparsingDependencyIndices.isEmpty()) {
            return List.of();
        }
        ArrayList<String> deletedPathsWithDefineTree = new ArrayList<String>();
        Map<String, PreprocessorRerunDefineTreesIndex.DefineTree> previousDefineTrees = this.parentPreprocessorRerunDefineTreesIndex.getDefineTrees(deletedUniformPaths);
        for (String path : deletedUniformPaths) {
            if (previousDefineTrees.get(path) == null) continue;
            deletedPathsWithDefineTree.add(path);
        }
        return deletedPathsWithDefineTree;
    }
}

