/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.util.Strings;
import org.conqat.engine.persistence.index.BidirectionalListIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="reparsing-dependency", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS})
public class PreprocessorIncludeReparsingDependencyIndex
extends IndexBase
implements IProjectIndex {
    private final BidirectionalListIndex<Integer, Integer> delegate;
    public static final String INDEX_NAME = "reparsing-dependency";

    public PreprocessorIncludeReparsingDependencyIndex(IStore store) {
        super(store, true);
        this.delegate = new BidirectionalListIndex((IStore)new DelegatingPartitionStore(store, "d"));
    }

    public static String buildDependencyTargetStorageKeyForIncludeName(String sanitizedIncludeName) {
        String includeNameWithUnixSeparators = FileSystemUtils.normalizeSeparatorsPlatformIndependently((String)sanitizedIncludeName);
        return Strings.toLowerCase((String)FileSystemUtils.getLastPathSegment((String)includeNameWithUnixSeparators));
    }

    public static String buildDependencyTargetStorageKeyForUniformPath(String uniformPath) {
        return Strings.toLowerCase((String)FileSystemUtils.getLastPathSegment((String)uniformPath));
    }

    public void putUpdatedValuesForChangedPaths(Map<String, ? extends List<String>> updatedValuesForChangedPaths, List<String> removedPaths) throws StorageException {
        HashSet<String> allUnabbreviatedKeyAndValues = new HashSet<String>();
        allUnabbreviatedKeyAndValues.addAll(updatedValuesForChangedPaths.keySet());
        updatedValuesForChangedPaths.values().forEach(allUnabbreviatedKeyAndValues::addAll);
        allUnabbreviatedKeyAndValues.addAll(removedPaths);
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(allUnabbreviatedKeyAndValues);
        HashMap<Integer, ArrayList> updatedAbbreviatedValues = new HashMap<Integer, ArrayList>();
        for (Map.Entry<String, ? extends List<String>> entry : updatedValuesForChangedPaths.entrySet()) {
            Integer abbreviatedUniformPath = (Integer)abbreviationMap.get(entry.getKey());
            ArrayList abbreviatedFileNames = entry.getValue().stream().map(abbreviationMap::get).collect(Collectors.toCollection(ArrayList::new));
            updatedAbbreviatedValues.put(abbreviatedUniformPath, abbreviatedFileNames);
        }
        List removedAbbreviatedPaths = removedPaths.stream().map(abbreviationMap::get).collect(Collectors.toList());
        this.delegate.updateValues(updatedAbbreviatedValues, removedAbbreviatedPaths);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<@Nullable List<String>> getPathsIncludingFileNames(List<String> potentiallyIncludedFileNames) throws StorageException {
        List abbreviatedFileNames = this.store.getAbbreviator().abbreviate(potentiallyIncludedFileNames);
        @Nullable List abbreviatedResultLists = this.delegate.getKeysForValues(abbreviatedFileNames);
        return this.unabbreviateListOfLists(abbreviatedResultLists);
    }

    private @NonNull List<@Nullable List<String>> unabbreviateListOfLists(List<@Nullable ArrayList<Integer>> abbreviatedResultLists) throws StorageException {
        HashSet allAbbreviatedPaths = new HashSet();
        abbreviatedResultLists.stream().filter(Objects::nonNull).forEach(allAbbreviatedPaths::addAll);
        Map unabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(allAbbreviatedPaths);
        ArrayList<@Nullable List<String>> result = new ArrayList<List<String>>();
        for (ArrayList<Integer> abbreviatedResultList : abbreviatedResultLists) {
            if (abbreviatedResultList == null) {
                result.add(null);
                continue;
            }
            result.add(abbreviatedResultList.stream().map(unabbreviationMap::get).collect(Collectors.toList()));
        }
        return result;
    }

    @VisibleForTesting
    public Map<String, List<String>> getAllEntriesByUniformPath() throws StorageException {
        Map allForwardEntries = this.delegate.getAllForwardEntries();
        Map<String, List<String>> result = this.unabbreviateMap(allForwardEntries);
        return result;
    }

    @VisibleForTesting
    public Map<String, List<String>> getAllEntriesByIncludedFilename() throws StorageException {
        Map allForwardEntries = this.delegate.getAllBackwardEntries();
        Map<String, List<String>> result = this.unabbreviateMap(allForwardEntries);
        return result;
    }

    private @NonNull Map<String, List<String>> unabbreviateMap(Map<Integer, ArrayList<Integer>> allForwardEntries) throws StorageException {
        HashSet allAbbreviatedKeyAndValues = new HashSet();
        allForwardEntries.keySet().forEach(allAbbreviatedKeyAndValues::add);
        allForwardEntries.values().forEach(allAbbreviatedKeyAndValues::addAll);
        Map unabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(allAbbreviatedKeyAndValues);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<Integer, ArrayList<Integer>> entry : allForwardEntries.entrySet()) {
            String key = (String)unabbreviationMap.get(entry.getKey());
            List value = entry.getValue().stream().map(unabbreviationMap::get).collect(Collectors.toList());
            result.put(key, value);
        }
        return result;
    }

    @VisibleForTesting
    public List<String> validateIndexConsistency() throws StorageException {
        return this.delegate.validateIndexConsistency();
    }
}

