/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.utils.EResourceType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class IndexResourceResolutionStrategyBase
implements IResourceResolutionStrategy {
    @Override
    public ContainerInfo getContainerInfoForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return IndexResourceResolutionStrategyBase.getContainerInfoForPath(uniformPath, this.openIndex(historyAccessOption));
    }

    @Override
    public List<ContainerInfo> getContainerInfosForPaths(List<UniformPath> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.openIndex(historyAccessOption).getContainers(uniformPaths.stream().map(UniformPath::toString).collect(Collectors.toList()));
    }

    @Override
    public EResourceType getResourceTypeForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.openIndex(historyAccessOption).getResourceType(uniformPath.toString());
    }

    @Override
    public Map<String, EResourceType> getResourceChildTypesForPath(UniformPath uniformPath, boolean includeChildFullPath, HistoryAccessOption historyAccessOption) throws StorageException {
        ContainerIndex index = this.openIndex(historyAccessOption);
        return this.getChildTypes(uniformPath.toString(), index);
    }

    protected abstract ContainerIndex openIndex(HistoryAccessOption var1) throws StorageException;

    protected Map<String, EResourceType> getChildTypes(String uniformPath, ContainerIndex index) throws StorageException {
        ContainerInfo parentInfo = index.getContainer(uniformPath);
        if (parentInfo == null) {
            return CollectionUtils.emptyMap();
        }
        return parentInfo.getChildrenWithResourceType();
    }

    private static ContainerInfo getContainerInfoForPath(UniformPath uniformPath, ContainerIndex index) throws StorageException {
        String path = uniformPath.toString();
        ContainerInfo container = index.getContainer(path);
        if (container == null && path.isEmpty()) {
            return new ContainerInfo("");
        }
        return container;
    }
}

