/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.retrieval_strategy.WorkItemHistoryAccessOptionExpander;
import com.teamscale.index.resource.utils.EResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public class SpecItemResourceResolutionStrategy
implements IResourceResolutionStrategy {
    private final ProjectStorageSystem projectStorageSystem;
    private final WorkItemHistoryAccessOptionExpander historyAccessOptionExpander;

    public SpecItemResourceResolutionStrategy(ProjectStorageSystem projectStorageSystem) {
        this.projectStorageSystem = projectStorageSystem;
        this.historyAccessOptionExpander = new WorkItemHistoryAccessOptionExpander(projectStorageSystem);
    }

    private ContainerIndex openIndex(HistoryAccessOption historyAccessOption) throws StorageException {
        return (ContainerIndex)this.projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", historyAccessOption);
    }

    @Override
    public ContainerInfo getContainerInfoForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        List<ContainerIndex> indices = this.openIndices(List.of(uniformPath), historyAccessOption);
        return SpecItemResourceResolutionStrategy.getContainerInfoForPath(uniformPath, indices);
    }

    @Override
    public List<ContainerInfo> getContainerInfosForPaths(List<UniformPath> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        List<ContainerIndex> indices = this.openIndices(uniformPaths, historyAccessOption);
        ArrayList<ContainerInfo> result = new ArrayList<ContainerInfo>(uniformPaths.size());
        for (UniformPath uniformPath : uniformPaths) {
            result.add(SpecItemResourceResolutionStrategy.getContainerInfoForPath(uniformPath, indices));
        }
        return result;
    }

    private static ContainerInfo getContainerInfoForPath(UniformPath uniformPath, List<ContainerIndex> indices) throws StorageException {
        String path = uniformPath.toString();
        ContainerInfo container = null;
        for (ContainerIndex index : indices) {
            container = SpecItemResourceResolutionStrategy.mergeContainers(container, index.getContainer(path));
        }
        return container;
    }

    private static ContainerInfo mergeContainers(ContainerInfo one, ContainerInfo two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        ContainerInfo info = new ContainerInfo(one.getUniformPath());
        for (ContainerInfo source : List.of(one, two)) {
            for (String child : source.getChildren()) {
                info.insertOrUpdateChildElementWithHash(child, source.getHash(child));
            }
            if (source.getDeepestRelativePathWithMoreThanOneChild().isEmpty()) continue;
            info.setDeepestRelativePathWithMoreThanOneChild(source.getDeepestRelativePathWithMoreThanOneChild());
        }
        if (info.getChildren().size() > 1) {
            info.setDeepestRelativePathWithMoreThanOneChild("");
        }
        return info;
    }

    @Override
    public EResourceType getResourceTypeForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        EResourceType result = EResourceType.UNKNOWN;
        for (ContainerIndex index : this.openIndices(List.of(uniformPath), historyAccessOption)) {
            EResourceType resourceType = index.getResourceType(uniformPath.toString());
            result = result.ordinal() < resourceType.ordinal() ? resourceType : result;
        }
        return result;
    }

    @Override
    public Map<String, EResourceType> getResourceChildTypesForPath(UniformPath uniformPath, boolean includeChildFullPath, HistoryAccessOption historyAccessOption) throws StorageException {
        HashMap<String, EResourceType> result = new HashMap<String, EResourceType>();
        for (ContainerIndex index : this.openIndices(List.of(uniformPath), historyAccessOption)) {
            result.putAll(SpecItemResourceResolutionStrategy.getChildTypes(uniformPath, includeChildFullPath, index));
        }
        return result;
    }

    private static Map<String, EResourceType> getChildTypes(UniformPath uniformPath, boolean includeChildFullPath, ContainerIndex index) throws StorageException {
        ContainerInfo parentInfo = index.getContainer(uniformPath.toString());
        if (parentInfo == null) {
            return CollectionUtils.emptyMap();
        }
        Function<Pair, String> keyMapper = ImmutablePair::getFirst;
        if (!includeChildFullPath) {
            keyMapper = keyMapper.andThen(path -> StringUtils.stripPrefix((String)path, (String)(String.valueOf(uniformPath) + UniformPathUtils.SEPARATOR)));
        }
        return index.getResourceTypes(new ArrayList<String>(parentInfo.getChildren())).stream().collect(Collectors.toMap(keyMapper, ImmutablePair::getSecond));
    }

    private @NonNull List<ContainerIndex> openIndices(List<UniformPath> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        List<HistoryAccessOption> historyAccessOptions = this.historyAccessOptionExpander.expandHistoryAccessOption(uniformPaths, historyAccessOption);
        return CollectionUtils.mapWithException(historyAccessOptions, this::openIndex);
    }
}

