/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.google.auth.oauth2.GoogleCredentials;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.s3.CredentialsProcess;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.IS3ClientFactory;
import com.teamscale.index.s3.S3Client;
import com.teamscale.index.s3.S3RegionUtils;
import com.teamscale.index.s3.S3UriParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProcessCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Platform;

public final class S3ClientFactory
implements IS3ClientFactory {
    private static final int REQUEST_TIMEOUT_MILLISECONDS = Math.toIntExact(Duration.ofSeconds(TeamscaleSystemProperties.S3_REQUEST_TIMEOUT_SECONDS.getValue().orElse(60).intValue()).toMillis());
    private static final boolean DISABLE_SSL_CERTIFICATE_VALIDATION_COMPLETELY = Boolean.getBoolean("com.teamscale.disable-ssl-certificate-validation");
    private @Nullable Map<String, IS3Client> clientOverwritesByUris = null;

    public static S3ClientFactory getInstance() {
        return Singleton.INSTANCE.instance;
    }

    @Override
    public IS3Client createForUri(IExternalCredentialsProvider externalCredentialsProvider, S3UriParser.ParsedUri parsedUri) throws StorageException {
        if (this.clientOverwritesByUris != null && this.clientOverwritesByUris.containsKey(parsedUri.getEndpoint())) {
            return this.clientOverwritesByUris.get(parsedUri.getEndpoint());
        }
        if (parsedUri.isGlobalS3Uri()) {
            return S3ClientFactory.createWithDefaultCredentialProvider();
        }
        return S3ClientFactory.createFromParsedUri(parsedUri, externalCredentialsProvider);
    }

    @Override
    public IS3Client createWithCredentialsProcess(String baseUri, CredentialsProcess credentialsProcess) {
        if (this.clientOverwritesByUris != null && this.clientOverwritesByUris.containsKey(baseUri)) {
            return this.clientOverwritesByUris.get(baseUri);
        }
        ArrayList<String> command = new ArrayList<String>();
        if (Platform.isWindows()) {
            command.add("cmd.exe");
            command.add("/C");
        } else {
            command.add("sh");
            command.add("-c");
        }
        command.add(credentialsProcess.createCommand());
        ProcessCredentialsProvider credentialsProvider = ProcessCredentialsProvider.builder().command(command).build();
        return new S3Client((software.amazon.awssdk.services.s3.S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3ClientFactory.getS3ClientBuilder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).overrideConfiguration(S3ClientFactory.createClientConfiguration())).forcePathStyle(Boolean.valueOf(true))).region(S3RegionUtils.extractRegionFromBaseUri(baseUri))).endpointOverride(URI.create(baseUri))).build(), (AwsCredentialsProvider)credentialsProvider);
    }

    @Override
    @TestOnly
    public synchronized void registerClientForTesting(String uri, @Nullable IS3Client client) throws IllegalStateException {
        if (this.clientOverwritesByUris == null) {
            this.clientOverwritesByUris = new HashMap<String, IS3Client>();
        }
        if (client == null) {
            this.clientOverwritesByUris.remove(uri);
            return;
        }
        if (this.clientOverwritesByUris.containsKey(uri)) {
            throw new IllegalStateException("Client already registered for URI '%s'.".formatted(uri));
        }
        this.clientOverwritesByUris.put(uri, client);
    }

    private static IS3Client createWithDefaultCredentialProvider() {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.builder().build();
        return new S3Client((software.amazon.awssdk.services.s3.S3Client)((S3ClientBuilder)S3ClientFactory.getS3ClientBuilder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build(), (AwsCredentialsProvider)credentialsProvider);
    }

    @VisibleForTesting
    static IS3Client createFromParsedUri(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider externalCredentialsProvider) throws StorageException {
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3ClientFactory.getS3ClientBuilder().forcePathStyle(Boolean.valueOf(true))).requestChecksumCalculation(RequestChecksumCalculation.WHEN_REQUIRED)).responseChecksumValidation(ResponseChecksumValidation.WHEN_REQUIRED);
        AwsCredentials credentials = S3ClientFactory.createCredentials(parsedUri, externalCredentialsProvider);
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        builder.credentialsProvider((AwsCredentialsProvider)credentialsProvider);
        if (credentials.providerName().filter("AnonymousCredentialsProvider"::equals).isPresent() && parsedUri.isGoogleCloudStorageUri()) {
            builder.overrideConfiguration(cfg -> cfg.addExecutionInterceptor((ExecutionInterceptor)GoogleCloudAuthenticationHandler.getApplicationDefault()));
        }
        return new S3Client((software.amazon.awssdk.services.s3.S3Client)((S3ClientBuilder)((S3ClientBuilder)builder.endpointOverride(URI.create(parsedUri.getEndpoint()))).region(S3RegionUtils.extractRegionFromBaseUri(parsedUri.getEndpoint()))).build(), (AwsCredentialsProvider)credentialsProvider);
    }

    private static AwsCredentials createCredentials(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        ExternalCredentials externalCredentials;
        if (parsedUri.getAccessKey() != null && parsedUri.getSecretKey() != null) {
            return AwsBasicCredentials.create((String)parsedUri.getAccessKey(), (String)parsedUri.getSecretKey());
        }
        if (credentialsProvider != null && (externalCredentials = credentialsProvider.getExternalCredentials(parsedUri.getEndpoint())) != null && parsedUri.getEndpoint().equals(externalCredentials.uri)) {
            return AwsBasicCredentials.create((String)externalCredentials.username, (String)externalCredentials.password);
        }
        return AnonymousCredentialsProvider.create().resolveCredentials();
    }

    private static S3ClientBuilder getS3ClientBuilder() {
        S3ClientBuilder builder = software.amazon.awssdk.services.s3.S3Client.builder();
        if (DISABLE_SSL_CERTIFICATE_VALIDATION_COMPLETELY) {
            return (S3ClientBuilder)builder.httpClient(ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)true).build()));
        }
        return builder;
    }

    private static ClientOverrideConfiguration createClientConfiguration() {
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(REQUEST_TIMEOUT_MILLISECONDS)).build();
    }

    private static enum Singleton {
        INSTANCE(new S3ClientFactory());

        private final S3ClientFactory instance;

        private Singleton(S3ClientFactory instance) {
            this.instance = instance;
        }
    }

    @VisibleForTesting
    record GoogleCloudAuthenticationHandler(GoogleCredentials credentials) implements ExecutionInterceptor
    {
        @VisibleForTesting
        GoogleCloudAuthenticationHandler(GoogleCredentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
        }

        public static GoogleCloudAuthenticationHandler getApplicationDefault() {
            try {
                return new GoogleCloudAuthenticationHandler(GoogleCredentials.getApplicationDefault());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create Google Cloud credentials", e);
            }
        }

        public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
            try {
                return (SdkHttpRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("Authorization", "Bearer " + this.getToken()).build();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to obtain Google Cloud token", e);
            }
        }

        private String getToken() throws IOException {
            this.credentials.refreshIfExpired();
            return this.credentials.getAccessToken().getTokenValue();
        }
    }
}

